/*!
 * DataSourceCombo.hpp
 * \author Jeshua Bratman
 *
 * Widget and class to handle data source selection.
 */


#include "CEBLViewGTK.hpp"

#include "DataSourceCombo.hpp"
#include "cppR/cppR.hpp"
#include "Exceptions.hpp"
using namespace std;


//constructor
DataSourceCombo::DataSourceCombo(CEBLViewGTK *view)
{
  this->view = view;
  this->updating_view = false;
}

DataSourceCombo::~DataSourceCombo()
{

}


//create a new combo widget
GtkWidget * DataSourceCombo::getCombo()
{
  GtkWidget* combo = gtk_combo_box_new_text();

  this->combos.push_back(combo);
  this->num_sources.push_back(0);
  this->updateComboBox(combos.size()-1);

  g_signal_connect(G_OBJECT(combo),
        	   "changed",
        	   G_CALLBACK(CB_changeSource),
        	   (gpointer) this);
  return combo;
}

//update the view from the model
void DataSourceCombo::updateView()
{
  this->updating_view = true;
  for(unsigned int i=0;i<combos.size();i++)
    {
      this->updateComboBox(i);
    }
  this->updating_view = false;
}


//update a combo box from the model
void DataSourceCombo::updateComboBox(int index)
{
  GtkWidget * combo = combos[index];
  int num_sources = this->num_sources[index];

  //remove all the previous sources
  for(int i=num_sources-1;i>=0;i--)
    {
      gtk_combo_box_remove_text(GTK_COMBO_BOX(combo),i);
    }

  //get sources
  //re-add removed sources to combo box
  //find and store selected source and activate
  std::vector<string> sources = view->getModel()->dataGetSources();
  num_sources = sources.size();
  int selected = view->getModel()->dataGetSource();
  for(int i=0;i<num_sources;i++)
    {
      gtk_combo_box_append_text(GTK_COMBO_BOX(combo),sources[i].c_str());
      if(i == selected)
         this->selected_source = sources[i];
    }

  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),selected);

  this->num_sources[index] = num_sources;

}

//returns the name of the selected source
string DataSourceCombo::getSelectedSource()
{
  return this->selected_source;
}

//CALLBACKS

/*
 * Sets data source on combo box event
 */
void DataSourceCombo::CB_changeSource(GtkWidget * w, gpointer data)
{

  DataSourceCombo * d = (DataSourceCombo*)data;
  if(!d->updating_view)
    {
      //get source number and its string
      int source = gtk_combo_box_get_active(GTK_COMBO_BOX(w));
      d->selected_source = gtk_combo_box_get_active_text(GTK_COMBO_BOX(w));

      //set the source and update the gui to reflect selection
      //        (combo box and data source tab)
      d->view->getModel()->dataSetSource(source);
      d->view->updateView();
      d->updateView();
    }
}

