/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


/*!
 * DataSourceCombo.hpp
 * \author Jeshua Bratman
 *
 * Widget and class to handle data source selection.
 */


#ifndef DATASOURCECOMBO_H
#define DATASOURCECOMBO_H

#include "WidgetUtils.hpp"
#include <vector>
//forward defs
class CEBLViewGTK;



class DataSourceCombo
{
 private:
  CEBLViewGTK * view;
  //flag to indicate if view is being updated
  bool updating_view;

  //combo boxes
  std::vector<GtkWidget *> combos;
  std::vector<int> num_sources;

  //selected source
  string selected_source;

  //callbacks
  static void CB_changeSource(GtkWidget *, gpointer);

  //udate a combo box from the model
  void updateComboBox(int index);

 public:
  DataSourceCombo(CEBLViewGTK * view);
  ~DataSourceCombo();

  //! gets gtk widget to allow users to select data source
  GtkWidget *getCombo();

  //! update view from model
  void updateView();

  //! get a string representing the selected source
  string getSelectedSource();
};
#endif

