/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! EEGMonitor.cpp
 * \author Jeshua Bratman
 *
 * Widget to display a graph of many EEG channels using EEGPlot.
 * This class is tied into the whole cebl gui.
 */



#ifndef EEGMONITOR_H
#define EEGMONITOR_H


//include ublas
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/vector.hpp>
namespace ublas = boost::numeric::ublas;


#include "CEBLGtkWidgetDetachable.hpp"
#include "EEGPlot.hpp"

//forward declarations
class EEGDataSource;
class Tab;

class EEGMonitor : public CEBLGtkWidgetDetachable
{
 private:
  //all the widgets used in the monitor
  GtkWidget *scroll_window,
    *plot_box,
    *box_controls,
    *box_controls2,
    *spin_samples,
    *spin_zoom;

  //actual plotting widget
  EEGPlot *plot;

  //parent tab
  Tab * parent_tab;

  //max number of samples to display
  int num_display_samples;
  int num_channels;
  double zoom;

  //plotting
  bool continue_plotting;
  bool plot_wait;
  bool initialized;

  //channel configuration
  std::vector<std::string> labels;
  std::vector<bool> enabled;

  //CALLBACKS
  static void CB_ChangeNumSamples(GtkWidget *, gpointer);
  static void CB_ChangeZoom(GtkWidget *, gpointer);

 public:
  //constructors
  EEGMonitor(Tab *parent_tab, int nchannels = -1);
  ~EEGMonitor();

  //initialization
  void init();
  //call to create plot
  void initPlot();
  //remove old plot and create new ones
  void reInitPlot(int nchannels = -1);
  //setters/getters for various options
  //! Should the user controls be available?
  void setControlsVisible(bool);
  //! Set labels for the plot
  void setLabels(std::vector<std::string> labels);
  //! Set number of samples to display
  void setNumDisplaySamples(int);
  //! Set the zoom factor
  void setZoom(double);


  //plotting
  //! Plot a matrix of data or EEGData where rows are channels and columns are samples.
  void Plot(ublas::matrix<double> data);

  //! get a pointer to the parent tab
  Tab * getParentTab() { return parent_tab;}
};

#endif

