/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! EEGPlot.hpp
 * \author Jeshua Bratman
 *
 * A gtk plot for eeg data
 */


#ifndef EEGPLOT_H
#define EEGPLOT_H


// gtk includes
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>

// gktextra includes
#include <gtkextra/gtkplot.h>
#include <gtkextra/gtkplotdata.h>
#include <gtkextra/gtkplotcanvas.h>
#include <gtkextra/gtkplotcanvasplot.h>
#include <gtkextra/gtkplotcanvastext.h>

// include ublas
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/vector.hpp>
namespace ublas = boost::numeric::ublas;

class EEGMonitor;

class EEGPlot
{
 private:
  GtkWidget *current_plot;
  gint num_layers;
  GtkWidget *canvas;
  GtkWidget *vbox_container;
  GtkPlotCanvasChild *lines;

  //points two dimensional arrays for each channel and each sample
  GtkPlotData **datasets;
  double **px;
  double **py;
  std::vector<std::string> labels;
  int num_samples;
  int num_display_samples;
  double zoom;

  //max number of channels with space allocated for them
  int num_channels;

  //number of channels currently plotted
  int num_plotted_channels;
  int ymax;

  //has the plot been initialized
  bool initialized;

  //restraints of graph
  double x1,x2,y1,y2;
  double height;

  //size of plotting window
  double window_width, window_height;

  //background colors
  int BG_RED;
  int BG_GREEN;
  int BG_BLUE;

  //create a new layer
  GtkWidget *newLayer(GtkWidget *canvas);

  //functions to handle queued redraws
  static gint timedRedraw(gpointer);
  gint redraw_timeout_id;


 public:
  EEGPlot(int num_channels);
  ~EEGPlot();
  operator GtkWidget*();

  //Initialize plot
  void init();
  //Plot data in window
  void plot(ublas::matrix<double>);
  //Redraw the plot
  void redraw();

  //queues a redraw to be run in a specified time
  void queueRedraw();


  //setters to configure how the plot should display

  //! Sets the labels for each channel
  void setLabels(std::vector<std::string> labels);
  //! Inform of the width of container plot is in.
  void setWindowWidth(double width);
  //! Inform of the height of container plot is in.
  void setWindowHeight(double height);
  //! Set the background color for the plot as RGB
  void setBGColor(int red, int green, int blue) { BG_RED = red; BG_GREEN = green; BG_BLUE = blue; }
  //! Sets the number of samples to display at a time
  void setNumDisplaySamples(int n);
  //! Sets zoom factor
  void setZoom(double zoom);

  // getters

  //! How many samples are being displayed at once?
  int getDisplaySamples() { return num_display_samples; };


};


#endif

