/*
 * InfoBar.cpp
 * \author Alex Klein
 *
 * Displays information at bottom of CEBL window about several settings
 * and object statuses regardless of current tab
 */
#include "InfoBar.hpp"

InfoBar::InfoBar(CEBLViewGTK * v)
{
  this->cebl_gtk_widget_container = gtk_hbox_new(false, 10);

  //instantiate labels
  for(int i=0;i<n_labels;i++){
    this->setWidgetContainer(GTK_WIDGET(gtk_label_new(NULL)));
  }

  this->view = v;

  n_lags=0;
  n_classes=0;
  trained = false;
  classifier = "";
  c_trained = false;
  //Set label text
  this->update();

  gtk_widget_show_all(cebl_gtk_widget_container);
}

InfoBar::~InfoBar()
{

}

void InfoBar::update(){

  //gchar * for label text
  gchar * text;
  //string representation of label text used to convert from string to gchar
  string str_text;

  //buffer used for integer to string conversions
  //max lags = 500 = 3 characters
  //max classes = 50 = 2 characters
  char buffer[3];

  //Get labels from container
  GList* labels = gtk_container_get_children(
      GTK_CONTAINER(this->getContainer()));

  //Make sure current feature is lag and update lags label
  if (this->view->getModel()->featuresGetSelected()=="Lag")
    {//Lags label

    std::map<std::string, CEBL::Param> params =
        this->view->getModel()->featureGetParams();

    n_lags = params["lags"].getInt();
    //convert int lags to string
    std::sprintf(buffer,"%d",n_lags);
    str_text = "Number of Lags: " + string(buffer);
    text = (gchar *) str_text.c_str();

    gtk_label_set_text(GTK_LABEL(labels->data), text);
    }//end lags label

  labels=labels->next;

  {//Classes label
    n_classes = this->view->getModel()->trainingGetNumClasses();
    //convert int classes to string
    std::sprintf(buffer,"%d", n_classes);
    str_text = "Number of Classes: " + string(buffer);
    text = (gchar *)str_text.c_str();
    gtk_label_set_text(GTK_LABEL(labels->data), text);
  }

  labels=labels->next;

  {//Training data label
    trained = this->view->getModel()->trainingDataIsLoaded();
    if(trained)
      text = (gchar *)"Training Data Ready: true";
    else
      text = (gchar *)"Training Data Ready: false";
    gtk_label_set_text(GTK_LABEL(labels->data), text);
  }
  labels=labels->next;

  {//Classifier label
    classifier = this->view->getModel()->classifiersGetSelected();
    str_text = "Classifier: " + classifier;
    text = (gchar *)str_text.c_str();
    gtk_label_set_text(GTK_LABEL(labels->data), text);
  }
  labels=labels->next;

  {//Classifier Trained label
    c_trained = this->view->getModel()->classifierIsTrained();
    if(c_trained)
      text = (gchar *)"Classifier Trained: true";
    else
      text = (gchar *)"Classifier Trained: false";
    gtk_label_set_text(GTK_LABEL(labels->data), text);
  }
}
