/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
*
*/

/*
 * InfoBar.hpp
 * \author Alex Klein
 *
 * Displays information at bottom of CEBL window about several settings
 * and object statuses regardless of current tab
 */

#ifndef INFO_BAR_H
#define INFO_BAR_H
#include "CEBLViewGTK.hpp"
#include "CEBLGtkWidget.hpp"
#include <stdlib.h>


class InfoBar : public CEBLGtkWidget{

private:
  CEBLViewGTK * view;
  static const int n_labels = 5;
  //Number of lags
  int n_lags;
  //Number of classes
  int n_classes;
  //Training data ready?
  bool trained;
  //Classifier Name
  string classifier;
  //Classifier Trained?
  bool c_trained;

public:
  InfoBar(CEBLViewGTK * view);
  ~InfoBar();

  //update labels' text
  void update();

  //void show();
  //void hide();
};

#endif
