/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * InterfaceCombo.hpp
 * \author Jeshua Bratman
 *
 * Combo box factory for uniform selection of training interfaces.
 */


#ifndef INTERFACECOMBO_H
#define INTERFACECOMBO_H


#include "WidgetUtils.hpp"
#include <vector>

//forward defs
class CEBLViewGTK;
class EEGInterface;

class InterfaceCombo
{
 private:
  CEBLViewGTK * view;

  //flag to indicate if view is being updated
  bool updating_view;

  //combo boxes
  std::vector<GtkWidget *> combos;
  std::vector<int> num_interfaces;

  //selected interface id
  int selected_interface;

  //list of selectable interfaces
  std::vector<string> interfaces;
  std::vector<EEGInterface *> interface_pointers;

  //callbacks
  static void CB_changeInterface(GtkWidget *, gpointer);

  //udate a combo box from the model
  void updateComboBox(int index);

 public:
  InterfaceCombo(CEBLViewGTK * view);
  ~InterfaceCombo();

  //! gets gtk widget to allow users to select interface
  GtkWidget *getCombo();

  //! gets pointer to selected interface
  EEGInterface * getInterface();
  //! gets id of selected interface
  int getSelectedInterfaceID();

  //! update view from model
  void updateView();

};
#endif

