/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * InterfaceConfigurationWindow.hpp
 * \author Jeshua Bratman
 *
 * Options window for configuring EEG training and classifying.
 */

#ifndef INTERFACECONFIGURATIONWINDOW_H
#define INTERFACECONFIGURATIONWINDOW_H

#include <gtk/gtk.h>
#include "WidgetUtils.hpp"
#include <vector>

//forward defs
class CEBLViewGTK;
class EEGInterface;
class WidgetPanel;

/*!
Interface configuration window provides a gui to enter
class labels and other configuration options for the EEG
training and classying interface.
*/
class InterfaceConfigurationWindow
{
private:
  CEBLViewGTK * view;

  GtkWidget * window, btn_apply;
  std::vector<GtkWidget *> class_labels_entries;
  std::vector<GtkWidget *> open_close_buttons;
  std::vector<string> class_labels;
  WidgetPanel *interface_parameters_panel;
  bool updating_view;
  bool window_open;
  bool window_created;


  //! create window gui
  void createWindow();
  //! close window
  void closeWindow();
  //! open window
  void openWindow();

  //! called whenever any open/close button is pressed
  static void CB_openCloseWindow(GtkWidget *widget,gpointer);
  //! callback when deleting window
  static gboolean CB_windowDelete(GtkWidget *widget, GdkEvent *event, gpointer data);
  //! callback when closing window
  static void CB_windowClose(GtkWidget *widget,gpointer);

  //! apply configuration to model and interface
  void applyConfig();

public:
  InterfaceConfigurationWindow(CEBLViewGTK *view);
  ~InterfaceConfigurationWindow();

  //! returns a button widget to open/close the configuration window
  GtkWidget * getButton();

  //! returns list of class labels as set in configuration
  std::vector<string> getClassLabels();

  //! update the view from model
  void updateView();
};

#endif

