/*! StatusBar.hpp
 * \author Jeshua Bratman
 *
 */

#include "StatusBar.hpp"
#include <iostream>

StatusBar::StatusBar()
{
   status_bar = gtk_statusbar_new();
   this->setWidgetContainer(status_bar);
   this->show();
   this->volatile_msg = false;
   this->timed_msg = false;
}

StatusBar::~StatusBar()
{

}

//! remove the message with specified id from status bar stack
void StatusBar::remove(StatusID &id)
{
  if(id.message_id > 0)
    {
      gtk_statusbar_remove(GTK_STATUSBAR(status_bar), id.context_id, id.message_id);
      id.message_id = -1;
    }
}

//! pop the top message on the stack
void StatusBar::pop()
{
  this->volatile_msg = false;
  this->timed_msg = false;

  if(id_stack.empty())
    return;
  int id = id_stack.top().context_id;
  id_stack.pop();
  gtk_statusbar_pop(GTK_STATUSBAR(status_bar),id);
}

//! used by pushTimed to pop a timed message from the stack
gint StatusBar::timedPop(gpointer parent)
{
  StatusBar* bar = (StatusBar*)parent;
  if(bar->timed_msg)
    {
      bar->pop();
      bar->volatile_msg = false;
      bar->timed_msg = false;
    }
  return false;
}

//! push a message onto the stack, and return its id
StatusID StatusBar::push(string message)
{
  if(this->volatile_msg)
    {
      this->pop();
      this->volatile_msg = false;
      this->timed_msg = false;
    }

  int cid = gtk_statusbar_get_context_id(GTK_STATUSBAR(status_bar), message.c_str());
  int mid = gtk_statusbar_push(GTK_STATUSBAR(status_bar), cid, message.c_str());

  StatusID id;
  id.context_id = cid;
  id.message_id = mid;

  id_stack.push(id);
  gtk_main_iteration();

  return id;
}

//! push a message onto the stack which will be removed when another message is added
StatusID StatusBar::pushVolatile(string message)
{
  StatusID id = push(message);
  this->volatile_msg = true;
  return id;
}

//! push a message which only appears for a short time and then pops
//  ms is number of milliseconds to wait, 2000 by default
StatusID StatusBar::pushTimed(string message,int ms)
{
  StatusID id = pushVolatile(message);
  timed_msg = true;
  g_timeout_add(ms, timedPop, this);
  return id;
}



