/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! StatusBar.hpp
 * \author Jeshua Bratman
 *
 * Class to push and pop short status messages.
 */

#ifndef STATUSBAR_H
#define STATUSBAR_H

#include "CEBLGtkWidget.hpp"
#include <string>
#include <stack>

using namespace std;

//! ID of a status message. Makes it easy to keep track of different statuses.
class StatusID
{
public:

  int context_id;
  int message_id;

  StatusID()
  {
    context_id = -1;
    message_id = -1;
  }


};

class StatusBar : public CEBLGtkWidget
{
private:
  //The status bar
  GtkWidget* status_bar;
  //Stack of message IDs
  stack<StatusID> id_stack;
  //Flag set when volatile message is pushed
  bool volatile_msg;
  //Flag set when timed message is pushed
  bool timed_msg;

  //used by pushTimed to pop a timed message from the stack
  static gint timedPop(gpointer);

public:
  StatusBar();
  ~StatusBar();

  //! remove the message with specified id from status bar stack
  void remove(StatusID &id);

  //! pop the top message on the stack
  void pop();

  //! push a message onto the stack, and return its id
  StatusID push(string message);

  //! push a message onto the stack which will be removed when another message is added
  StatusID pushVolatile(string message);

  //! push a message which only appears for a short time and then pops, ms is number of milliseconds to wait
  StatusID pushTimed(string message,int ms=2000);

};

#endif


