#include "Tab.hpp"

#include <sstream>
using namespace std;


Tab::Tab(string title, GtkWidget *notebook, CEBLViewGTK * view)
{
  this->view = view;
  this->title = title;
  container = gtk_vbox_new(FALSE,0);
  if(notebook!=NULL)
    {
      string text = "<small>" + title + "</small>";
      GtkWidget * label = gtk_label_new("");
      gtk_label_set_markup(GTK_LABEL(label),text.c_str());
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook),container,label);
    }
  //gtk_notebook_set_tab_reorderable(GTK_NOTEBOOK(notebook),container,true);
  //gtk_notebook_set_tab_detachable(GTK_NOTEBOOK(notebook),container,true);
  gtk_widget_show_all(container);

  this->notebook_id = gtk_notebook_page_num(GTK_NOTEBOOK(notebook),container);
}

Tab::~Tab()
{

}

string Tab::GetTitle()
{
  return title;
}

GtkWidget *Tab::GetContainer()
{
  return container;
}

void Tab::TabRemove(GtkWidget *widget)
{
  gtk_container_remove(GTK_CONTAINER(container),widget);
}

//! Add a widget to the tab.
void Tab::TabAdd(GtkWidget * widget, bool expand, bool fill, int padding)
{
  gtk_box_pack_start(GTK_BOX(container), widget, expand, fill, padding);
  gtk_widget_show_all(widget);
}

//! Add a widget to the tab
void Tab::TabAdd(GtkWidget * widget)
{
  TabAdd(widget, false, false, 2);
}

//! Add a widget to a frame inside the tab.
void Tab::TabFrameAdd(GtkWidget * widget, const char * title, bool expand, bool fill)
{
  TabAdd(TabFrameCreate(widget, title), expand, fill, 5);
}

//! Creates a standardized frame containing the widget to add to the tab
GtkWidget *Tab::TabFrameCreate(GtkWidget * widget, const char * title)
{
  GtkWidget *outer_align = gtk_alignment_new(0,0,1,1);
  GtkWidget *frame = gtk_frame_new(title);
  GtkWidget *inner_align = gtk_alignment_new(0,0,0,1);

  gtk_container_add(GTK_CONTAINER(inner_align),widget);
  gtk_alignment_set_padding(GTK_ALIGNMENT(inner_align),5,5,5,5);

  gtk_container_add(GTK_CONTAINER(frame),inner_align);

  gtk_container_add(GTK_CONTAINER(outer_align),frame);
  gtk_alignment_set_padding(GTK_ALIGNMENT(outer_align),5,5,5,5);

  return outer_align;
}


