/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * Tab.hpp
 * \author Jeshua Bratman
 *
 * Base class for tabbed view of CEBL
 */



#ifndef TAB_H
#define TAB_H

#include "CEBLViewGTK.hpp"
#include "TextUtils.hpp"

using std::string;


class Tab
{
 protected:

  //! pointer to view
  CEBLViewGTK * view;

  //! main container to hold tab contents
  GtkWidget *container;

  //! title of the tab
  string title;

  //! id of tab in notebook
  int notebook_id;

  //! Add a widget to the tab.
  void TabAdd(GtkWidget *, bool expand, bool fill, int padding);

  //! Add a widget to the tab;
  void TabAdd(GtkWidget *);

  //! Add a widget to a frame inside the tab.
  void TabFrameAdd(GtkWidget *, const char * title = "", bool expand = false, bool fill = false);

  //! Function to create a standardized from.
  GtkWidget *TabFrameCreate(GtkWidget * widget, const char * title="");

  //! Remove a widget from the tab
  void TabRemove(GtkWidget *);

 public:
  // Constructors / Destructors
  Tab(string title, GtkWidget * notebook, CEBLViewGTK * view);
  virtual ~Tab();

  //! Get the title of the tab.
  string GetTitle();

  //! Get the container widget.
  GtkWidget *GetContainer();

  //! Get the parent view
  CEBLViewGTK *getView() { return view; }


  //! Updates the view from the model
  virtual void updateView() = 0;
  //! updates model from view
  virtual void updateModel() = 0;
  //! optional function to be called when page is hidden
  virtual void onHide() {}
  //! optional function to be called when page is selected
  virtual void onShow() {}

};
#endif

