/*!
 * TabClassifiers.cpp
 * \author Jeshua Bratman
 *
 */

#include "TabClassifiers.hpp"

//----------------------------------------------------------------------
// Constructors / Destructor

TabClassifiers::~TabClassifiers()
{

}


//----------------------------------------------------------------------
// Create the GUI


void TabClassifiers::CreateGUI()
{
  //add title
  GtkWidget *title = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(title),view->getString("ClassifierTitle"));
  TabAdd(title);
  TabAdd(gtk_hseparator_new());


  //-------------------------------------------------
  //Classifier Selection
  GtkWidget *hbox_classifiers = gtk_hbox_new(false, 0);

  this->updating_view = false;
  this->num_classifiers = 0;
  this->selected_classifier = "";
  combo_classifiers = gtk_combo_box_new_text();

  //configure the combo box and add callback
  gtk_combo_box_set_active(GTK_COMBO_BOX(combo_classifiers),0);
  g_signal_connect(G_OBJECT(combo_classifiers),
                   "changed",
                   G_CALLBACK(CB_ChangeClassifier),
                   (gpointer) this);

  gtk_box_pack_start(GTK_BOX(hbox_classifiers), combo_classifiers, false, false, 0);

  //trained check box
  check_classifier_trained =
    gtk_check_button_new_with_label(view->getString("ClassifiersStr1"));
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_classifier_trained),
                               false);
  gtk_widget_set_sensitive(check_classifier_trained,false);

  gtk_box_pack_end(GTK_BOX(hbox_classifiers),check_classifier_trained,
                   false, false, 0);



  TabAdd(hbox_classifiers);

  //create space for widget panel
  panel_box = gtk_hbox_new(false, 0);
  panel = NULL;

  TabFrameAdd(panel_box,view->getString("ClassifiersStr2"));


  updateView();
  if(gtk_combo_box_get_active(GTK_COMBO_BOX(combo_classifiers))==-1)
    gtk_combo_box_set_active(GTK_COMBO_BOX(combo_classifiers),0);
}



//update view from model

void TabClassifiers::updateView()
{

  //set flag to indicate process of updating view
  //in order to stop callbacks from triggering
  this->updating_view = true;

  //get information from model about classifiers
  CEBLModel * model = getView()->getModel();
  std::vector<string> names = model->classifiersGetNameList();
  std::vector<string> paths = model->classifiersGetPathList();
  string model_selected_classifier = model->classifiersGetSelected();


  {
    this->selected_classifier = model_selected_classifier;
    this->classifier_names = names;
    for(int i = this->num_classifiers-1; i >= 0; i--)
      {
        gtk_combo_box_remove_text(GTK_COMBO_BOX(combo_classifiers),i);
      }
    this->num_classifiers = names.size();

    // add in all classifiers

    for(unsigned int i=0;i<names.size();i++)
      {
        gtk_combo_box_append_text(GTK_COMBO_BOX(combo_classifiers),names[i].c_str());
        if(names[i]==model_selected_classifier)
          {
            gtk_combo_box_set_active(GTK_COMBO_BOX(combo_classifiers),i);
          }
      }
    //set trained checked button
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_classifier_trained),
                                 model->classifierIsTrained());

    // create panel
    if (this->panel != NULL)
      {
        gtk_container_remove(GTK_CONTAINER(this->panel_box),this->panel->getContainer());
        delete this->panel;
        this->panel = NULL;
      }

    //update panel
    if(model_selected_classifier != "")
      {
        try
          {
            std::map<std::string, CEBL::Param> params = model->classifierGetParams(model_selected_classifier);
            this->panel = new WidgetPanel(params);
          }
        catch(...)
          {
            this->panel = NULL;
            cerr << "ERROR: exception occurred when trying to get parameters for classifier.\n";
          }
      }
    if (this->panel != NULL)
      {
        gtk_container_add(GTK_CONTAINER(this->panel_box),this->panel->getContainer());
        gtk_widget_show_all(this->panel_box);

      }
  }//end of conditional concerning whether update should occur
  this->updating_view = false;
}


//update the model from the widgets
void TabClassifiers::updateModel()
{
  // set the selected classifiers's params
  if(this->panel != NULL){
    this->getView()->getModel()->classifierSetParams(this->panel->getParams());
  }
}

//----------------------------------------------------------------------
// CALLBACKS


void TabClassifiers::CB_ChangeClassifier(GtkWidget *w, gpointer data)
{
  TabClassifiers* tab = (TabClassifiers*)data;

  //as long as the update view is not currently running,
  //set the model's selected classifier to the selected classifier
  //in combo box
  if(tab->num_classifiers > 0 && !tab->updating_view)
    {
      string classifier = gtk_combo_box_get_active_text(GTK_COMBO_BOX(tab->combo_classifiers));
      try
        {
          if(classifier != tab->selected_classifier)
            {
              // set the previously selected classifier's params
              if(tab->panel != NULL){
                tab->getView()->getModel()->classifierSetParams(tab->panel->getParams());
              }
              // set the selected classifier in the model
              tab->getView()->getModel()->classifiersSetSelected(classifier);

            }
        }
      catch(...)
        {
          cerr << "Error selecting classifier.\n";
        }
      tab->updateView();
      tab->getView()->updateInfoBar();
    }

}




