/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabClassifiers.hpp
 * \author Jeshua Bratman
 *
 * Tab containing options for classifiers
 */


#ifndef TABCLASSIFIERS_H
#define TABCLASSIFIERS_H

#include "Tab.hpp"
#include "WidgetPanel.hpp"
#include "../model/EEGData.hpp"

class TabClassifiers : public Tab
{
private:
  GtkWidget *btn_start,
    *btn_stop,
    *btn_train,
    *combo_classifiers,
    *panel_container,
    *panel_box,
    *check_classifier_trained,
    *hbox_classifiers;


  //classifiers
  WidgetPanel *panel;
  int sample_rate;
  std::vector<string> classifier_names;
  string selected_classifier;
  bool updating_view;

  int num_classifiers;


  //CALLBACKS
  static void CB_ChangeClassifier(GtkWidget *, gpointer);
  static void CB_TrainClassifier(GtkWidget *, gpointer);

protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabClassifiers(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabClassifiers();

  //update the view
  void updateView();
  //update model
  void updateModel();
};


#endif



