/*!
 * TabDecision.cpp
 * \author Jeshua Bratman
 *
 */

#include "TabDecision.hpp"
#include <gtk/gtk.h>

//----------------------------------------------------------------------
// Constructors / Destructor

TabDecision::~TabDecision()
{

}


//----------------------------------------------------------------------
// Create the GUI


void TabDecision::CreateGUI()
{
  //add title
  GtkWidget *title = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(title),view->getString("DecisionTitle"));
  TabAdd(title);
  TabAdd(gtk_hseparator_new());



  //-------------------------------------------------
  //Decision Selection
  GtkWidget *hbox_decision = gtk_hbox_new(false, 0);

  this->updating_view = false;
  this->num_decision = 0;
  this->selected_decision = "";
  combo_decision = gtk_combo_box_new_text();

  //configure the combo box and add callback
  gtk_combo_box_set_active(GTK_COMBO_BOX(combo_decision),0);
  g_signal_connect(G_OBJECT(combo_decision),
        	   "changed",
        	   G_CALLBACK(CB_ChangeDecision),
        	   (gpointer) this);

  gtk_box_pack_start(GTK_BOX(hbox_decision), combo_decision, false, false, 0);

  TabAdd(hbox_decision);

  //create space for widget panel
  panel_box = gtk_hbox_new(false, 0);
  panel = NULL;

  TabFrameAdd(panel_box,view->getString("DecisionStr1"));



  updateView();

  if(gtk_combo_box_get_active(GTK_COMBO_BOX(combo_decision))==-1)
    gtk_combo_box_set_active(GTK_COMBO_BOX(combo_decision),0);
}


//update view from model

void TabDecision::updateView()
{
  //set flag to indicate process of updating view
  //in order to stop callbacks from triggering
  this->updating_view = true;

  //get information from model about decision
  CEBLModel * model = getView()->getModel();
  std::vector<string> names = model->decisionGetNameList();
  std::vector<string> paths = model->decisionGetPathList();
  string model_selected_decision = model->decisionGetSelected();


  {
    this->selected_decision = model_selected_decision;
    this->decision_names = names;
    for(int i = this->num_decision-1; i >= 0; i--)
      {
        gtk_combo_box_remove_text(GTK_COMBO_BOX(combo_decision),i);
      }
    this->num_decision = names.size();

    // add in all decision
    for(unsigned int i=0;i<names.size();i++)
      {
        gtk_combo_box_append_text(GTK_COMBO_BOX(combo_decision),names[i].c_str());
        if(names[i]==model_selected_decision)
          {
            gtk_combo_box_set_active(GTK_COMBO_BOX(combo_decision),i);
          }
      }

    // create panel
    if (this->panel != NULL)
      {
        gtk_container_remove(GTK_CONTAINER(this->panel_box),this->panel->getContainer());
        delete this->panel;
        this->panel = NULL;
      }

    //update panel
    if(model_selected_decision != "")
      {
        try
          {
            std::map<std::string, CEBL::Param> params = model->decisionGetParams(model_selected_decision);
            this->panel = new WidgetPanel(params);
          }
        catch(...)
          {
            this->panel = NULL;
            cerr << "ERROR: exception occured when trying to get parameters for decision.\n";
          }
      }
    if (this->panel != NULL)
      {
        gtk_container_add(GTK_CONTAINER(this->panel_box),this->panel->getContainer());
        gtk_widget_show_all(this->panel_box);

      }
  }//end of conditional concerning whether update should occur

  this->updating_view = false;
}

//update the model from the widgets
void TabDecision::updateModel()
{
  // set the selected decision's params
  if(this->panel != NULL){
    this->getView()->getModel()->decisionSetParams(this->panel->getParams());
  }
}

//! this function is called whenever a different tab is selected
void TabDecision::onHide()
{

}


//----------------------------------------------------------------------
// CALLBACKS


void TabDecision::CB_ChangeDecision(GtkWidget *w, gpointer data)
{
  TabDecision* tab = (TabDecision*)data;

  //as long as the update view is not currently running,
  //set the model's selected decision to the selected decision
  //in combo box
  if(tab->num_decision > 0 && !tab->updating_view)
    {
      string decision = gtk_combo_box_get_active_text(GTK_COMBO_BOX(tab->combo_decision));
      try
        {
          if(decision != tab->selected_decision)
            {
              // set the previously selected decision's params
              if(tab->panel != NULL){
        	tab->getView()->getModel()->decisionSetParams(tab->panel->getParams());
              }
              // now tell model what decision is selected
              tab->getView()->getModel()->decisionSetSelected(decision);

            }
        }
      catch(...)
        {
          cerr << "Error selecting decision.\n";
        }
      tab->updateView();
    }

}





