/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabDecision.hpp
 * \author Jeshua Bratman
 *
 * Tab containing options for decision
 */


#ifndef TABDECISION_H
#define TABDECISION_H

#include "Tab.hpp"
#include "WidgetPanel.hpp"


class TabDecision : public Tab
{
private:

 private:
  GtkWidget *combo_decision,
    *panel_container,
    *panel_box,
    *hbox_decision;


  //decision
  WidgetPanel *panel;
  std::vector<string> decision_names;
  string selected_decision;
  bool updating_view;
  int num_decision;


  //CALLBACKS
  static void CB_ChangeDecision(GtkWidget *, gpointer);

protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabDecision(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabDecision();

  //update the view
  void updateView();
  //update model
  void updateModel();
  //update decision when hidden
  void onHide();
};


#endif



