/*!
 * Tabdevice.cpp
 * \author Jeshua Bratman
 *
 */

#include "TabDevice.hpp"
#include "DataSourceCombo.hpp"
#include "WidgetUtils.hpp"
#include "WidgetPanel.hpp"
#include "StatusBar.hpp"
//----------------------------------------------------------------------
// Constructors / Destructor

TabDevice::~TabDevice()
{
  delete mindset_panel;
}


//----------------------------------------------------------------------
// Create the GUI


void TabDevice::CreateGUI()
{
  //add title
  GtkWidget *title = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(title),"<big>Data Source</big>");
  TabAdd(title);
  TabAdd(gtk_hseparator_new());


  GtkWidget * box_data_selector = gtk_hbox_new(false, 0);
  gtk_box_pack_start(GTK_BOX(box_data_selector),this->getView()->getDataSource()->getCombo(),false,false,0);
  TabAdd(box_data_selector,false,false,0);

  //============================================================
  // Mindset Configuration
  mindset_device_box = gtk_vbox_new(false,0);

  //----------------------------------------


  mindset_panel = new WidgetPanel;
  mindset_panel->add("DeviceLocation","Where is the device located?",getView()->getModel()->deviceGetLocation());
  g_signal_connect(G_OBJECT(mindset_panel->getWidget(0)),
        	   "changed",
        	   G_CALLBACK(CB_ChangeLocation),
        	   (gpointer) this);

  gtk_box_pack_start(GTK_BOX(mindset_device_box),gtk_label_new("Mindset Configuration"),false,false,0);
  gtk_box_pack_start(GTK_BOX(mindset_device_box),gtk_hseparator_new(),false,false,0);
  gtk_box_pack_start(GTK_BOX(mindset_device_box),mindset_panel->getContainer(),false,false,0);



  //-------------------------
  //search button
  btn_search = gtk_button_new_with_label("Search For Amplifier");
  g_signal_connect(G_OBJECT(btn_search),
        	   "clicked",
        	   G_CALLBACK(CB_DeviceSearch),
        	   (gpointer) this);
  GtkWidget *btn_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(btn_box),GTK_BUTTONBOX_SPREAD);
  gtk_box_pack_start(GTK_BOX(btn_box),btn_search, false, false, 0);


  gtk_box_pack_start(GTK_BOX(mindset_device_box),btn_box,false,false,0);

  //-------------------------
  //error frame
  GdkColor color;
  gdk_color_parse ("red", &color);

  GtkWidget *error_frame = gtk_frame_new("");
  GtkWidget *error_label = gtk_label_new("Device Errors");
  gtk_widget_modify_fg(error_label, GTK_STATE_NORMAL, &color);
  gtk_frame_set_label_widget(GTK_FRAME(error_frame),error_label);


  gtk_widget_set_size_request(error_frame,500,220);
  error_text = gtk_label_new("Device Configuration Errors");
  gtk_label_set_line_wrap(GTK_LABEL(error_text),true);

  //error box
  gtk_container_add(GTK_CONTAINER(error_frame),error_text);
  error_box = gtk_hbox_new(true, 0);
  gtk_box_pack_start(GTK_BOX(error_box),error_frame,false, false, 40);

  gtk_box_pack_start(GTK_BOX(mindset_device_box),error_box,false,false,0);
  //-------------------------
  inquiry_box = gtk_hbox_new(false, 0);
  inquiry_text = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(inquiry_box),inquiry_text,true,true,25);

  gtk_box_pack_start(GTK_BOX(mindset_device_box),inquiry_box,false,false,0);


  TabAdd(mindset_device_box);
  //============================================================
  // File Configuration
  file_stream_box = gtk_vbox_new(false,0);
  string loaded_file = "None";

  //button box for load file button
  GtkWidget *file_btn_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(btn_box),GTK_BUTTONBOX_START);

  file_btn_load = gtk_button_new_with_label("Load File");
  g_signal_connect(G_OBJECT(file_btn_load),
        	   "clicked",
        	   G_CALLBACK(CB_LoadDataSourceFile),
        	   (gpointer) this);
  gtk_box_pack_start(GTK_BOX(file_btn_box),file_btn_load,false,false,2);

  //label to indicate name of loaded file
  GtkWidget *label_file = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(label_file),"<b>Loaded File: </b>");
  label_filename = gtk_label_new(loaded_file.c_str());
  GtkWidget *hbox_filename = gtk_hbox_new(false,0);

  gtk_box_pack_start(GTK_BOX(file_stream_box),file_btn_box, false, false, 2);

  gtk_box_pack_start(GTK_BOX(hbox_filename),label_file,false,false,0);
  gtk_box_pack_start(GTK_BOX(hbox_filename),label_filename,false,false,0);


  gtk_box_pack_start(GTK_BOX(file_stream_box),hbox_filename, false, false, 2);


  //data info labels
  file_label_info_text = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(file_stream_box),file_label_info_text, false, false, 2);

  //pack file stream configuration box into the tab
  TabAdd(file_stream_box);

  this->updating_view = false;
}

//update the view from the model
void TabDevice::updateView()
{
  this->updating_view = true;

  string source_name = this->getView()->getDataSource()->getSelectedSource();
  gtk_widget_hide(this->mindset_device_box);
  gtk_widget_hide(this->file_stream_box);
  if(source_name == "Mindset")
    {
      //set status message
      StatusID status_id = this->getView()->getStatusBar()->push("Searching for NeuroPulse Mindset...");

      //get inquiry about device
      string inquiry = this->getView()->getModel()->deviceGetInquiry();
      string error = this->getView()->getModel()->deviceGetError();
      string location = this->getView()->getModel()->deviceGetLocation();


      //set device location
      gtk_entry_set_text(GTK_ENTRY(mindset_panel->getWidget(0)),location.c_str());

      //show/hide error box
      if(!this->getView()->getModel()->deviceIsReady())
        {
          gtk_widget_show(error_box);
          gtk_label_set_text(GTK_LABEL(error_text),error.c_str());
        }
      else
        {
          gtk_widget_hide(error_box);
        }

      //show/hide inquiry box
      if(inquiry != "")
        {
          gtk_widget_show(inquiry_box);
          gtk_label_set_text(GTK_LABEL(inquiry_text),inquiry.c_str());
        }
      else
        {
          gtk_widget_hide(inquiry_box);
        }
        gtk_widget_show(this->mindset_device_box);

        //remove status message
        this->getView()->getStatusBar()->remove(status_id);
    }
  else if(source_name=="File")
    {
      string filename = this->getView()->getModel()->fileStreamGetFilename();
      int num_samples  = this->getView()->getModel()->fileStreamGetNumSamples();
      int num_channels  = this->getView()->getModel()->fileStreamGetNumChannels();
      int sample_rate  = this->getView()->getModel()->fileStreamGetSampleRate();
      int num_classes  = this->getView()->getModel()->fileStreamGetNumClasses();
      int num_sequences  = this->getView()->getModel()->fileStreamGetNumSequences();

      gtk_label_set_markup(GTK_LABEL(this->label_filename),filename.c_str());

      if(num_samples == 0 || num_channels < 2)
        {
          gtk_widget_hide(this->file_label_info_text);
        }
      else
        {
          string info_string = "Channels:\t " + TextUtils::IntToString(num_channels) + "\n"
            + "Samples:\t " + TextUtils::IntToString(num_samples) + "\n"
            + "Sample Rate: " + TextUtils::IntToString(sample_rate) + "\n";

          if(num_classes > 0)
            {
              info_string += "<b>Data is separated into</b>:\n "
        	+ TextUtils::IntToString(num_classes) + " classes and "
        	+ TextUtils::IntToString(num_sequences) + " sequences per class.\n";

            }

          gtk_label_set_markup(GTK_LABEL(this->file_label_info_text),info_string.c_str());
          gtk_widget_show(this->file_label_info_text);
        }


      gtk_widget_show(this->file_stream_box);
    }
  this->updating_view = false;
}


//update the model from the widgets
void TabDevice::updateModel()
{

}

//----------------------------------------------------------------------
// CALLBACKS

void TabDevice::CB_DeviceSearch(GtkWidget *widget, gpointer data)
{
  TabDevice * tab = (TabDevice *)data;
  if(tab->updating_view)
    return;
  StatusID status_id = tab->getView()->getStatusBar()->push("Searching for NeuroPulse Mindset...");
  tab->getView()->getModel()->deviceSearch();
  tab->getView()->getStatusBar()->remove(status_id);
  tab->updateView();
}
void TabDevice::CB_ChangeLocation(GtkWidget *widget, gpointer data)
{
  TabDevice * tab = (TabDevice *)data;
  if(tab->updating_view)
    return;

  tab->getView()->getModel()->deviceSetDeviceLocation(gtk_entry_get_text(GTK_ENTRY(tab->mindset_panel->getWidget(0))));
  tab->updateView();
}
void TabDevice::CB_ChangeBlockSize(GtkWidget *widget, gpointer data)
{
  //  TabDevice * tab = (TabDevice *)data;

}
void TabDevice::CB_ChangeSampleRate(GtkWidget *widget, gpointer data)
{
  //TabDevice * tab = (TabDevice *)data;
}


//-------------------------------------------------
// callbacks for file configuration
void TabDevice::CB_LoadDataSourceFile(GtkWidget *widget, gpointer data)
{
  TabDevice * tab = (TabDevice *)data;


  string filename = WidgetUtils::selectLoadFile();
  if(filename == "")
    return;


  try
    {
      //send this file load to the controller
      WidgetUtils::waitBoxShow("Loading data file...",false);
      tab->getView()->getModel()->fileStreamOpenFile(filename);
      WidgetUtils::waitBoxHide();
    }
  catch(exception e)
    {
      WidgetUtils::waitBoxHide();
      string message = string("Failed to open file. ") + e.what();
      WidgetUtils::AlertError("Error",message);
    }


  //update the channels widgets
  tab->updateView();

}

