/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabDevice.hpp
 * \author Jeshua Bratman
 *
 * Tab containing widgets regarding the EEG source.
 */


#ifndef TABDEVICE_H
#define TABDEVICE_H

#include "Tab.hpp"
class WidgetPanel;


class TabDevice : public Tab
{
private:
  //Widgets for device configuration
  WidgetPanel *mindset_panel;
  GtkWidget *error_text;
  GtkWidget *error_box;
  GtkWidget *inquiry_text;
  GtkWidget *inquiry_box;
  GtkWidget *radio_bs_96, *radio_bs_192, *radio_bs_384, *radio_bs_768;
  GtkWidget *radio_sr_64, *radio_sr_128, *radio_sr_256, *radio_sr_512, *radio_sr_1024;
  GtkWidget *mindset_options_box;
  GtkWidget *btn_search;
  GtkWidget *mindset_device_box;


  //CALLBACKS
  static void CB_DeviceSearch(GtkWidget *, gpointer);
  static void CB_ChangeLocation(GtkWidget *, gpointer);
  static void CB_ChangeBlockSize(GtkWidget *, gpointer);
  static void CB_ChangeSampleRate(GtkWidget *, gpointer);

  //are the widgets currently being updated from the model
  bool updating_view;

  //Widgets for file stream configuration
  GtkWidget *file_stream_box,
    *label_filename,
    *file_btn_load,
    *file_label_info_text;



  static void CB_LoadDataSourceFile(GtkWidget *, gpointer);


protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabDevice(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabDevice();

  //update the view
  void updateView();
  //update model
  void updateModel();
};


#endif

