/*!
 * TabEEGRecording.cpp
 * \author Jeshua Bratman
 *
 */

#include "TabEEGRecording.hpp"
#include "WidgetUtils.hpp"
#include "TextUtils.hpp"
#include <fstream>
//----------------------------------------------------------------------
// Constructors / Destructor

TabEEGRecording::~TabEEGRecording()
{

}


//----------------------------------------------------------------------
// Create the GUI


void TabEEGRecording::CreateGUI()
{
  //add title
  GtkWidget *title = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(title),view->getString("RecordingTitle"));
  TabAdd(title);
  TabAdd(gtk_hseparator_new());




  //----------------------------------------
  // Get CEBL model values values


  string channel_config_file = getView()->getModel()->channelsGetConfigFilename();
  num_channel_boxes = getView()->getModel()->channelsGetMaxNumChannels();


  //----------------------------------------
  // Initialize widget arrays
  enabled_boxes.resize(num_channel_boxes);
  reference_boxes.resize(num_channel_boxes);
  entry_electrode_names.resize(num_channel_boxes);


  //----------------------------------------
  // Top button box
  GtkWidget *config_file_box = gtk_vbox_new(false, 0);
  GtkWidget *btn_box = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(btn_box),GTK_BUTTONBOX_START);

  control_btn_load = gtk_button_new_with_label(view->getString("RecordingStr1"));
  g_signal_connect(G_OBJECT(control_btn_load),
                   "clicked",
                   G_CALLBACK(CB_LoadChannelsFile),
                   (gpointer) this);


  control_btn_save = gtk_button_new_with_label(view->getString("RecordingStr2"));
  g_signal_connect(G_OBJECT(control_btn_save),
                   "clicked",
                   G_CALLBACK(CB_SaveChannelsFile),
                   (gpointer) this);


  control_btn_clear = gtk_button_new_with_label(view->getString("RecordingStr3"));
  g_signal_connect(G_OBJECT(control_btn_clear),
                   "clicked",
                   G_CALLBACK(CB_ClearChannels),
                   (gpointer) this);


  gtk_box_pack_start(GTK_BOX(btn_box),control_btn_load,false,false,2);
  gtk_box_pack_start(GTK_BOX(btn_box),control_btn_save,false,false,2);
  gtk_box_pack_start(GTK_BOX(btn_box),control_btn_clear,false,false,2);

  //----------------------------------------
  // File name box
  GtkWidget *label_file = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(label_file),view->getString("RecordingStr4"));
  label_filename = gtk_label_new(channel_config_file.c_str());
  GtkWidget *hbox_filename = gtk_hbox_new(false,0);

  gtk_box_pack_start(GTK_BOX(hbox_filename),label_file,false,false,0);
  gtk_box_pack_start(GTK_BOX(hbox_filename),label_filename,false,false,0);

  gtk_box_pack_start(GTK_BOX(config_file_box),btn_box, false, false, 2);
  gtk_box_pack_start(GTK_BOX(config_file_box),hbox_filename, false, false, 2);

  TabFrameAdd(config_file_box);

  //----------------------------------------
  // Channel boxes

  suppress_channel_callbacks = false;

  GtkWidget *main_hbox = gtk_hbox_new(false,0);

  const int cols = 4;
  GtkWidget *channels_hbox = gtk_hbox_new(false,0);
  GtkWidget *channels_table = gtk_table_new(num_channel_boxes + 1, cols,false);

  //add some padding between rows and columns
  gtk_table_set_row_spacings(GTK_TABLE(channels_table),1);
  gtk_table_set_col_spacings(GTK_TABLE(channels_table),10);

  //top row labels
  GtkWidget * label1 = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(label1),view->getString("RecordingStr5"));
  GtkWidget * label2 = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(label2),view->getString("RecordingStr6"));
  GtkWidget * label3 = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(label3),view->getString("RecordingStr7"));
  GtkWidget * label4 = gtk_label_new("");
  gtk_label_set_markup(GTK_LABEL(label4),view->getString("RecordingStr8"));

  gtk_table_attach(GTK_TABLE(channels_table)
                   ,label1
                   ,0,1,0,1,
                   GTK_FILL, GTK_SHRINK,0,0);
  gtk_table_attach(GTK_TABLE(channels_table)
                            ,label2
                            ,1,2,0,1,GTK_FILL,GTK_SHRINK,0,0);
  gtk_table_attach(GTK_TABLE(channels_table)
                            ,label3
                            ,2,3,0,1,GTK_FILL,GTK_SHRINK,0,0);
  gtk_table_attach(GTK_TABLE(channels_table)
                            ,label4
                            ,3,4,0,1,GTK_FILL,GTK_SHRINK,0,0);

  //create all check boxes, entries, and labels
  for(int i=0;i<num_channel_boxes;i++)
    {
      //first column
      gtk_table_attach(GTK_TABLE(channels_table)
                                ,gtk_label_new(TextUtils::IntToString(i+1).c_str())
                                ,0,1,i+1,i+2,GTK_FILL,GTK_SHRINK,0,0);

      entry_electrode_names[i] = gtk_entry_new_with_max_length(10);
      g_signal_connect(G_OBJECT(entry_electrode_names[i]),
                   "changed",
                   G_CALLBACK(CB_ChangeChannel),
                   (gpointer) this);

      //gtk_entry_set_text(GTK_ENTRY(label_entry[i]),electrode_labels[i]->c_str());
      gtk_widget_set_size_request(entry_electrode_names[i], 30, 20);//make the entry box small and sleek
      gtk_table_attach(GTK_TABLE(channels_table)
                                ,entry_electrode_names[i]
                                ,1,2,i+1,i+2,GTK_FILL,GTK_SHRINK,0,0);

      reference_boxes[i] = gtk_check_button_new();
      g_signal_connect(G_OBJECT(reference_boxes[i]),
                   "toggled",
                   G_CALLBACK(CB_ChangeChannel),
                   (gpointer) this);
      gtk_table_attach(GTK_TABLE(channels_table)
                                ,reference_boxes[i]
                                ,2,3,i+1,i+2,GTK_FILL,GTK_SHRINK,0,0);


      enabled_boxes[i] = gtk_check_button_new();
      g_signal_connect(G_OBJECT(enabled_boxes[i]),
                   "toggled",
                   G_CALLBACK(CB_ChangeChannel),
                   (gpointer) this);
      gtk_table_attach(GTK_TABLE(channels_table)
                                ,enabled_boxes[i]
                                ,3,4,i+1,i+2,GTK_FILL,GTK_SHRINK,0,0);
    }


  GtkWidget * scroll_window = gtk_scrolled_window_new(NULL,NULL);
  gtk_container_border_width(GTK_CONTAINER(scroll_window),0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_window),
                                 GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);


  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll_window),channels_table);
  gtk_widget_set_size_request(scroll_window,300,-1);
  gtk_box_pack_start(GTK_BOX(channels_hbox), scroll_window, false, false, 0);

  gtk_box_pack_start(GTK_BOX(main_hbox), TabFrameCreate(channels_hbox, view->getString("RecordingStr9")), false, false, 0);



  //----------------------------------------
  // Data Process Frame

  //MAKE TREE MODEL

  GtkListStore *store;
  GtkTreeIter iter;
  store = gtk_list_store_new(NUM_COLS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_INT);

  //REFERENCE
  gtk_list_store_append(store, &iter);
  gtk_list_store_set(store, &iter,
                     COL_CHECK, true,
                     COL_VALUE, view->getString("RecordingStr10"),
                     COL, PROCESS_REFERENCE,
                     -1);

  //ENABLED
  gtk_list_store_append(store, &iter);
  gtk_list_store_set(store, &iter,
                     COL_CHECK, true,
                     COL_VALUE, view->getString("RecordingStr11"),
                     COL, PROCESS_ENABLED,
                     -1);

  //FILTER
  gtk_list_store_append(store, &iter);
  gtk_list_store_set(store, &iter,
                     COL_CHECK, false,
                     COL_VALUE, view->getString("RecordingStr12"),
                     COL, PROCESS_FILTER,
                     -1);
 //MAKE TREE
  GtkCellRenderer     *renderer;
  GtkTreeModel        *model;
  GtkWidget           *view;
  GtkTreeViewColumn   *col;
  GtkTreeSelection    *selection;


  view = gtk_tree_view_new();

  //HANDLE SELECTION
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
  gtk_tree_selection_set_select_function(selection, CB_SelectProcess, this, NULL);



  //COLUMN 1
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, this->view->getString("RecordingStr13"));
  gtk_tree_view_append_column(GTK_TREE_VIEW(view), col);
  renderer = gtk_cell_renderer_toggle_new();
  g_signal_connect(renderer, "toggled", (GCallback) CB_ToggleProcess, this);

  gtk_cell_renderer_toggle_set_active(GTK_CELL_RENDERER_TOGGLE(renderer), true);
  g_object_set(renderer, "activatable", TRUE, NULL);
  gtk_tree_view_column_pack_start(col, renderer, TRUE);

  gtk_tree_view_column_set_attributes(col, renderer,
                                      "active", COL_CHECK,
                                      NULL);

  //COLUMN 2
  col = gtk_tree_view_column_new();
  gtk_tree_view_append_column(GTK_TREE_VIEW(view), col);
  gtk_tree_view_column_set_title(col, this->view->getString("RecordingStr14"));
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_column_pack_start(col, renderer, TRUE);
  gtk_tree_view_column_set_attributes(col, renderer,
                                      "text", COL_VALUE,
                                      NULL);

  //APPLY MODEL
  model = GTK_TREE_MODEL(store);
  this->tree_model = model;
  gtk_tree_view_set_model(GTK_TREE_VIEW(view),model);


  g_object_unref(model);

  gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(view)),
                              GTK_SELECTION_BROWSE);
  gtk_widget_show_all(GTK_WIDGET(view));

  //PANE
  GtkWidget *process_pane = gtk_vpaned_new();
  gtk_widget_show(process_pane);

  gtk_paned_pack1(GTK_PANED(process_pane),view, true,true);


  //MAKE DESCRIPTION VIEWER
  description_viewer = gtk_text_view_new();
  gtk_text_view_set_editable(GTK_TEXT_VIEW(description_viewer),false);
  gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(description_viewer),false);
  gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(description_viewer),GTK_WRAP_WORD);
  gtk_widget_set_size_request (description_viewer, 250, 110);

  GtkWidget * frame = TabFrameCreate(description_viewer,this->view->getString("RecordingStr15"));
  gtk_paned_pack2(GTK_PANED(process_pane),frame,false,false);


  //Add the box to the tab
  gtk_box_pack_start(GTK_BOX(main_hbox), TabFrameCreate(process_pane, this->view->getString("RecordingStr16")), false,false, 0);

  //----------------------------------------
  TabAdd(main_hbox,true,true,5);


  //update view from model
  updateView();
}

//----------------------------------------------------------------------
// UPDATE WIDGETS

void TabEEGRecording::updateView()
{
  suppress_channel_callbacks = true;
  CEBLModel * model = getView()->getModel();
  for(int i=0; i<num_channel_boxes; i++)
    {
      gtk_entry_set_text(GTK_ENTRY(entry_electrode_names[i]),
                         model->channelsGetElectrodeName(i).c_str());
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(reference_boxes[i]),
                                   model->channelsGetElectrodeReference(i));
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enabled_boxes[i]),
                                   model->channelsGetElectrodeEnabled(i));
    }
  string markup = getView()->getModel()->channelsGetConfigFilename();
  gtk_label_set_markup(GTK_LABEL(label_filename),markup.c_str());


  //update process
  GtkTreeIter iter;
  gtk_tree_model_get_iter_first(GTK_TREE_MODEL(tree_model),&iter);

  do
    {
      DataProcessID id = PROCESS_REFERENCE;
      gtk_tree_model_get(tree_model, &iter, COL, &id, -1);

      switch(id)
        {
        case PROCESS_REFERENCE:
          gtk_list_store_set(GTK_LIST_STORE(tree_model), &iter,
                             COL_CHECK,
                             (getView()->getModel()->processGetReferenceEnabled()),
                             -1);
          break;
        case PROCESS_ENABLED:
          gtk_list_store_set(GTK_LIST_STORE(tree_model), &iter,
                             COL_CHECK,
                             (getView()->getModel()->processGetRemoveEnabled()),
                             -1);
          break;
        case PROCESS_FILTER:
          gtk_list_store_set(GTK_LIST_STORE(tree_model), &iter,
                             COL_CHECK,
                             (getView()->getModel()->processGetFilterEnabled()),
                             -1);
          break;
        default:
          break;
        }
    }
  while(gtk_tree_model_iter_next(GTK_TREE_MODEL(tree_model),&iter));

  suppress_channel_callbacks = false;
}

//update model from view
void TabEEGRecording::updateModel()
{

}

//----------------------------------------------------------------------
// CALLBACKS



void TabEEGRecording::CB_LoadChannelsFile(GtkWidget * w, gpointer data)
{
  TabEEGRecording *tab = (TabEEGRecording*)(data);

  string filename = WidgetUtils::selectLoadFile();
  if(filename != "")
    {
      try
        {
          tab->getView()->getModel()->channelsLoadFile(filename.c_str());
        }
      catch(FileException e)
        {
          WidgetUtils::AlertError(tab->view->getString("RecordingStr17"),
                                  tab->view->getString("RecordingStr18"));
        }
    }
  //update the channels widgets
  tab->updateView();
}


void TabEEGRecording::CB_SaveChannelsFile(GtkWidget * w, gpointer data)
{
  TabEEGRecording *tab = (TabEEGRecording*)(data);
  string filename = WidgetUtils::selectSaveFile("conf");
  if(filename != "")
    {
      try
        {
          tab->getView()->getModel()->channelsSaveFile(filename);
        }
      catch(FileException e)
        {
          WidgetUtils::AlertError(tab->view->getString("RecordingStr17"),
                                  tab->view->getString("RecordingStr19"));
        }
    }
}


void TabEEGRecording::CB_ClearChannels(GtkWidget *w, gpointer data)
{
  TabEEGRecording *tab = (TabEEGRecording*)(data);

  for(int i=0; i < tab->num_channel_boxes; i++)
    {
      gtk_entry_set_text(GTK_ENTRY(tab->entry_electrode_names[i]),"");
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tab->reference_boxes[i]), 
                                   false);
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tab->enabled_boxes[i]),
                                   false);
      tab->getView()->getModel()->channelsSetElectrodeName(i,"");
      tab->getView()->getModel()->channelsSetElectrodeEnabled(i,false);
      tab->getView()->getModel()->channelsSetElectrodeReference(i,false);
    }
}


//toggle a process in the gui
void TabEEGRecording::CB_ToggleProcess(GtkCellRendererToggle *cell,
                                       gchar *path,
                                       gpointer userdata)
{
  TabEEGRecording *tab = (TabEEGRecording*)(userdata);
  //return if callback is suppressed
  if(tab->suppress_channel_callbacks) return;


  GtkTreeIter iter;
  bool this_selected = 
    gtk_tree_model_get_iter_from_string(tab->tree_model, &iter, path);
  if(this_selected)
    {
      gboolean selected = false;
      DataProcessID id = PROCESS_REFERENCE;
      gtk_tree_model_get(tab->tree_model, &iter, COL_CHECK, &selected, -1);
      gtk_tree_model_get(tab->tree_model, &iter, COL, &id, -1);
      gtk_list_store_set(GTK_LIST_STORE(tab->tree_model), &iter,
                         COL_CHECK, !selected,
                         -1);

      switch(id)
        {
        case PROCESS_REFERENCE:
          tab->getView()->getModel()->processSetReferenceEnabled(!selected);
          break;
        case PROCESS_ENABLED:
          tab->getView()->getModel()->processSetRemoveEnabled(!selected);
          break;
        case PROCESS_FILTER:
          tab->getView()->getModel()->processSetFilterEnabled(!selected);
          break;
        default:
          break;
        }
    }
}


//select a process
gboolean TabEEGRecording::CB_SelectProcess (GtkTreeSelection *selection,
                                            GtkTreeModel     *model,
                                            GtkTreePath      *path,
                                            gboolean          path_currently_selected,
                                            gpointer          userdata)
{



  //get tab pointer
  TabEEGRecording *tab = (TabEEGRecording*)(userdata);

  //if this is already selected, ignore it
  if(path_currently_selected)
    return true;

  //get iterator
  GtkTreeIter iter;
  if(gtk_tree_model_get_iter(model, &iter, path))
    {
      int id = -1;
     gtk_tree_model_get(model, &iter, COL, &id, -1);

      //SET DESCRIPTIONS
      GtkTextBuffer * buffer;
      GtkWidget *view = tab->description_viewer;
      buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));
      switch(id)
        {
        case PROCESS_ENABLED:
          gtk_text_buffer_set_text(buffer,
                                   tab->view->getString("RecordingStr20"), -1);

          break;
        case PROCESS_REFERENCE:
          gtk_text_buffer_set_text(buffer,
                                  tab->view->getString("RecordingStr21"), -1);

          break;
        case PROCESS_FILTER:
          gtk_text_buffer_set_text(buffer,
                                   tab->view->getString("RecordingStr22"), -1);
          break;
        default:
          break;
        }
    }
  return true;
}



//update all the channel values in the model from gui
void TabEEGRecording::CB_ChangeChannel(GtkWidget *w, gpointer data)
{
  TabEEGRecording *tab = (TabEEGRecording*)(data);
  //return if callback is suppressed
  if(tab->suppress_channel_callbacks) return;

  for(int i=0; i<tab->num_channel_boxes;i++)
    {
      tab->getView()->getModel()->channelsSetElectrodeName(i,gtk_entry_get_text(GTK_ENTRY(tab->entry_electrode_names[i])));
      tab->getView()->getModel()->channelsSetElectrodeEnabled(i,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tab->enabled_boxes[i])));
      tab->getView()->getModel()->channelsSetElectrodeReference(i,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tab->reference_boxes[i])));
    }
}


