/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabEEGRecording.hpp
 * \author Jeshua Bratman
 *
 * Tab containing parameters for the recording of EEG
 */


#ifndef TABEEGRECORDING_H
#define TABEEGRECORDING_H

#include "Tab.hpp"

class TabEEGRecording : public Tab
{
private:


  // Layout Widgets
  GtkWidget *label_filename;
  vector<GtkWidget *> enabled_boxes;
  vector<GtkWidget *> reference_boxes;
  vector<GtkWidget *> entry_electrode_names;
  int num_channel_boxes;
  bool suppress_channel_callbacks;

  //Data Process
  GtkWidget *description_viewer;
  GtkTreeModel *tree_model;


  // Control Widgets
  GtkWidget *control_btn_load,
    *control_btn_save,
    *control_btn_clear;

  // CALLBACKS

  //channels config
  static void CB_LoadChannelsFile(GtkWidget *, gpointer);
  static void CB_SaveChannelsFile(GtkWidget *, gpointer);
  static void CB_ClearChannels(GtkWidget *, gpointer);
  static void CB_ChangeChannel(GtkWidget *, gpointer);
  //data process
  static gboolean CB_SelectProcess(GtkTreeSelection *, GtkTreeModel *, GtkTreePath *, gboolean, gpointer);
  static void CB_ToggleProcess(GtkCellRendererToggle *, gchar *, gpointer);


protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabEEGRecording(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabEEGRecording();


  //update view
  void updateView();
  //update model
  void updateModel();
};



//! Enum for process selection tree
enum
  {
    COL_CHECK=0,
    COL_VALUE,
    COL,
    NUM_COLS
  };


//! IDs for different data processes
enum DataProcessID
  {
    PROCESS_REFERENCE,
    PROCESS_ENABLED,
    PROCESS_FILTER,
    NUM_PROCESS_IDS
  };

#endif

