/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabFeatures.hpp
 * \author Jeshua Bratman
 *
 * Tab containing options for features
 */


#ifndef TABFEATURES_H
#define TABFEATURES_H

#include "Tab.hpp"
#include "WidgetPanel.hpp"
#include "../model/EEGData.hpp"

//forward declarations
class EEGMonitor;

class TabFeatures : public Tab
{
private:

 private:
  GtkWidget *btn_start,
    *btn_stop,
    *btn_train,
    *combo_features,
    *panel_container,
    *panel_box,
    *check_feature_trained,
    *hbox_features;


  //features
  WidgetPanel *panel;
  int sample_rate;
  std::vector<string> feature_names;
  string selected_feature;
  bool updating_view;
  int num_features;
  int plot_size;

  //CALLBACKS
  static void CB_changeFeature(GtkWidget *, gpointer);
  static void CB_trainFeature(GtkWidget *, gpointer);
  static void CB_startPlot(GtkWidget *, gpointer);
  static void CB_stopPlot(GtkWidget *, gpointer);
  static gint timedPlot(gpointer);

  //PLOTTING
  EEGMonitor *plot;
  bool continue_plotting;

  void createPlot();
  void startPlotting();
  void stopPlotting();
  bool continuePlotting() { return continue_plotting; }

protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabFeatures(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabFeatures();

  //update the view
  void updateView();

  //update model
  void updateModel();

  //update features when hidden
  void onHide();
};


#endif



