/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabFilter.hpp
 * \author Jeshua Bratman
 *
 * Tab containing filtering options
 */


#ifndef TABFILTER_H
#define TABFILTER_H

#include "Tab.hpp"
#include "../model/EEGData.hpp"
#include "../model/Timer.hpp"

//forward declarations
class EEGMonitor;

class TabFilter : public Tab
{
private:
  GtkWidget * btn_show,
    *btn_create_filter,
    *entry_components,
    *label_selected,
    *btn_box1,
    *btn_box2,
    *btn_box3,
    *check_filter_made,
    *combo_filters,
    *btn_collect,
    *spin_lags,
    *spin_seconds;

  //EEGDataSource * data_source;
  EEGMonitor * plot;
  EEGData training_data;
  void createPlot(int);

  // CALLBACKS
  static void CB_selectComponents(GtkWidget *, gpointer);
  static void CB_showComponents(GtkWidget *, gpointer);
  static void CB_createFilter(GtkWidget *, gpointer);
  static void CB_changeFilter(GtkWidget *, gpointer);
  static void CB_changeNumLags(GtkWidget *, gpointer);
  static void CB_collectData(GtkWidget *, gpointer);
  static void CB_changeNumSeconds(GtkWidget *, gpointer);

  void startCollect();
  void stopCollect();
  bool is_collecting;
  bool training_collected;
  int num_seconds;
  Timer collect_timer;

  //changing filter and updating view
  std::vector<string> filter_names;
  string selected_filter;
  bool updating_view;
  int num_filters;

protected:
  //! Initialize the tab
  void CreateGUI();



public:

  //Constructors / Destructors
  TabFilter(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabFilter();

  //update the view
  void updateView();
  //update model
  void updateModel();
};


#endif



