/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabMonitor.hpp
 * \author Jeshua Bratman
 *
 * Tab containing monitor interface
 */


#ifndef TABMONITOR_H
#define TABMONITOR_H

#include "Tab.hpp"
#include "../model/EEGData.hpp"
#include "StatusBar.hpp"

//forward declaratiosn
class EEGMonitor;
class EEGDataSource;

class TabMonitor : public Tab
{
private:
  GtkWidget *btn_start,
    *btn_stop,
    *btn_start_collecting,
    *label_collected_seconds,
    *label_collected_samples,
    *progress_bar,
    *check_filter;

  EEGMonitor * plot;

  // CALLBACKS
  static void CB_StartMonitor(GtkWidget *, gpointer);
  static void CB_StopMonitor(GtkWidget *, gpointer);
  static void CB_StartCollect(GtkWidget *, gpointer);
  static void CB_StopCollect(GtkWidget *, gpointer);
  static void CB_toggleFilter(GtkWidget *, gpointer);

  //PLOTTING
  static gint timedPlot(gpointer);

  /*! Start the data source and return success
    
    \return success
  */
  bool startDataSource();
  void stopDataSource();

  void startPlotting();
  void stopPlotting();
  void createPlot();

  bool continue_plotting;
  bool collecting_data;
  bool continuePlotting() { return continue_plotting; }
  //passive plot indicates that we are plotting but not controlling the mindset
  bool passive_plot;
  StatusID status_id;
  bool updating_view;

protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabMonitor(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabMonitor();

  //update the view
  void updateView();
  //update model
  void updateModel();
  void onHide();
};

#endif



