/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabRealTimeClassification.hpp
 * \author Jeshua Bratman
 *
 * Tab for classifying real-time data and controlling interface.
 */


#ifndef TABREALTIMECLASSIFICATION_H
#define TABREALTIMECLASSIFICATION_H

#include "Tab.hpp"
#include "interfaces/EEGInterface.hpp"
#include "../model/EEGData.hpp"

//forward declarations
class InterfaceConfigurationWindow;

class TabRealTimeClassification : public Tab
{
private:
  bool updating_view;

  //WIDGETS
  GtkWidget *interface_combo,
    *source_combo,
    *interface_box,
    *controls_box,
    *btn_train_classifier,
    *btn_start,
    *btn_stop,
    *btn_interface_cfg;


  EEGInterface *interface;
  InterfaceConfigurationWindow * interface_config;

  void disableControls();
  void enableControls();

  static void CB_trainClassifier(GtkWidget *, gpointer);
  static void CB_start(GtkWidget *, gpointer);
  static void CB_stop(GtkWidget *, gpointer);

  //update interface based on num classes, and class labels
  void updateInterface();

  //update the interface during classification
  static gint timedUpdateInterface(gpointer);

protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabRealTimeClassification(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabRealTimeClassification();

  //update the view
  void updateView();
  //update model
  void updateModel();
  void onHide();
};

#endif



