/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * TabTraining.hpp
 * \author Jeshua Bratman
 *
 * Tab for collecting data and training classifiers.
 */


#ifndef TABTRAINING_H
#define TABTRAINING_H

#include "Tab.hpp"
#include "interfaces/EEGInterface.hpp"
#include "../model/EEGData.hpp"
#include "StatusBar.hpp"

//forward declarations
class InterfaceConfigurationWindow;

class TabTraining : public Tab
{
private:
  bool updating_view;

  //WIDGETS
  GtkWidget *interface_combo,
    *source_combo,
    *interface_box,
    *controls_box,
    *btn_start,
    *btn_stop,
    *btn_load,
    *btn_save,
    *btn_interface_cfg,
    *check_classification_feedback,
    *spin_classes,
    *spin_sequences,
    *spin_sequence_length,
    *spin_pause_length,
    *label_info,
    *label_data,
    *info_frame1,
    *info_frame2,
    *controls_hbox1,
    *controls_hbox2,
    *controls_hbox3,
    *controls_hbox4;

  EEGInterface *interface;
  bool training_stopped_manually;
  InterfaceConfigurationWindow * interface_config;
  void disableControls();
  void enableControls();
  static void CB_startTraining(GtkWidget *, gpointer);
  static void CB_stopTraining(GtkWidget *, gpointer);
  static void CB_changeNumClasses(GtkWidget *, gpointer);
  static void CB_changeNumSequences(GtkWidget *, gpointer);
  static void CB_changeSequenceLength(GtkWidget *, gpointer);
  static void CB_changePauseLength(GtkWidget *, gpointer);
  static void CB_loadData(GtkWidget *, gpointer);
  static void CB_saveData(GtkWidget *, gpointer);
  static void CB_toggleClassificationFeedback(GtkWidget *, gpointer);

  //update interface based on num classes, and class labels
  void updateInterface();
  //update text info to user
  void updateTextInfo();
  //update the interface during training process
  static gint timedUpdateInterface(gpointer);

  //status id
  StatusID status_id;

protected:
  //! Initialize the tab
  void CreateGUI();

public:

  //Constructors / Destructors
  TabTraining(string title, GtkWidget* notebook, CEBLViewGTK * view) : Tab(title,notebook,view) { CreateGUI(); }
  ~TabTraining();

  //update the view
  void updateView();
  //update model
  void updateModel();
  void onHide();
};

#endif



