/*!
 * ToolbarMenu.hpp
 * \author Jeshua Bratman
 *
 * Top menu for CEBL gtk view
 */

#include "CEBLViewGTK.hpp"
#include "ToolbarMenu.hpp"
#include "WidgetUtils.hpp"
#include "StatusBar.hpp"
#include <cstdlib>


static CEBLModel * model;
static CEBLViewGTK * view;

static const char *MenuUIXml =
"<ui>"
"  <menubar name='MainMenu'>"
"    <menu action='FileMenu'>"
"      <menuitem action='Save Session'/>"
"      <menuitem action='Save Session As'/>"
"      <menuitem action='Load Session'/>"
"      <menuitem action='Exit'/>"
"    </menu>"
"    <menu action='ToolsMenu'>"
"      <menuitem action='Preferences'/>"
"     "
"    </menu>"
"  </menubar>"
"</ui>";


//--------------------------------------------------
// Callback Stubs to attach to controller

//! Save session file as.
static void CB_saveSessionAs()
{
  view->updateModel();
  string filename = WidgetUtils::selectSaveFile("cbls");
  if(filename == "")
    return;
  try
    {
      model->sessionSaveAs(filename);
      view->getStatusBar()->pushTimed(view->getString("SessionStr1"));
    }
  catch(exception &e)
    {
      WidgetUtils::AlertError(view->getString("SessionStr2"),view->getString("SessionStr3")
        		      + string(e.what()));
      view->getStatusBar()->pushTimed(view->getString("SessionStr4"));
    }
}

//! Save Session File.
static void CB_saveSession()
{
  view->updateModel();
  if(model->sessionShouldSaveAs())
    {
      CB_saveSessionAs();
    }
  else
    {
      try
        {
          model->sessionSave();
          view->getStatusBar()->pushTimed(view->getString("SessionStr1"));
        }
      catch(exception &e)
        {
          WidgetUtils::AlertError(view->getString("SessionStr2"),view->getString("SessionStr5")
        			  + string(e.what()));
          view->getStatusBar()->pushTimed(view->getString("SessionStr4"));
        }
    }
}

//! Load Session File.
static void CB_loadSession()
{
  string filename = WidgetUtils::selectLoadFile();
  if(filename == "")
    return;
  try
    {
      model->sessionLoad(filename);
      view->getStatusBar()->pushTimed(view->getString("SessionStr6"));
    }
  catch(exception &e)
    {
      string msg = e.what();
      WidgetUtils::AlertError(view->getString("SessionStr7"),view->getString("SessionStr8")+msg);
      view->getStatusBar()->pushTimed(view->getString("SessionStr9"));
    }
  view->updateView();
}

//! exit the program
static void CB_exit()
{
  gtk_main_quit();
}

//! open preferences window
static void CB_openPreferences()
{

}

static GtkActionEntry entries[] = {
  { "FileMenu", NULL, "_File" },
  { "ToolsMenu", NULL, "_Tools" },
  { "Save Session", GTK_STOCK_SAVE, "Save Session", NULL, "Save Session", CB_saveSession},
  { "Save Session As", NULL, "Save Session As", NULL, "Save Session As", CB_saveSessionAs},
  { "Load Session", GTK_STOCK_OPEN, "L_oad Session", NULL, "Load Session", CB_loadSession},
  { "Exit", GTK_STOCK_QUIT, "E_xit", "<control>Q", "Exit the program", CB_exit },
  { "Preferences", GTK_STOCK_PREFERENCES, "_Preferences", "<control>P", "CEBL Preferences", CB_openPreferences}

};


ToolbarMenu::ToolbarMenu(CEBLViewGTK *v)
{
  view = v;
  model = v->getModel();
}


void ToolbarMenu::attachMenu(GtkWidget *window, GtkWidget *container)
{
  GtkWidget *menubar;
  GtkActionGroup *action_group;
  GtkUIManager *ui;
  GtkAccelGroup *accel_group;
  GError *error;

  //create action group
  action_group = gtk_action_group_new ("MenuActions");
  gtk_action_group_add_actions (action_group, entries, G_N_ELEMENTS (entries), window);
  /*
    Create Menu
  */
  ui = gtk_ui_manager_new();
  gtk_ui_manager_insert_action_group(ui, action_group, 0);
  accel_group = gtk_ui_manager_get_accel_group (ui);
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

  //Load the xml file
  error = NULL;
  //gtk_ui_manager_add_ui_from_string (ui_manager, ui_description, -1, &error)
  if(!gtk_ui_manager_add_ui_from_string(ui, MenuUIXml,-1, &error))
    {
      g_message("Creating Menu Failed: %s", error->message);
      g_error_free (error);
      exit(1);
    }
  //extract menu bar
  menubar = gtk_ui_manager_get_widget (ui, "/MainMenu");
  gtk_box_pack_start (GTK_BOX (container), menubar, FALSE, FALSE, 0);
  gtk_widget_show(menubar);
  //pack the items into a container
  gtk_widget_show_all(container);
  gtk_widget_show_all(window);
}



