/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


/*!
 * ToolbarMenu.hpp
 * \author Jeshua Bratman
 *
 * top menu for CEBL gtk view
 */

#ifndef TOOLBARMENU_H
#define TOOLBARMENU_H

#include <gtk/gtk.h>
#include <string>
using std::string;

class CEBLViewGTK;

/*!
Menu:
Menu is the top menu containing file, tools, help, etc.
*/
class ToolbarMenu
{
 private:
  GtkUIManager * ui;

 public:
  ToolbarMenu(CEBLViewGTK *);
  ~ToolbarMenu(){};

  //! attaches the menu to a window in a specified container
  void attachMenu(GtkWidget *window, GtkWidget *container);
};

#endif

