/*!
 * WidgetPanel.cpp
 * \author Jeshua Bratman
 *
 */


#include "WidgetPanel.hpp"
#include <vector>
#include <string>
#include <sstream>
#include <iostream>

using namespace std;
using namespace CEBL;

WidgetPanel::WidgetPanel()
{
  container = gtk_vbox_new(false,0);
  table = gtk_table_new(1,3,false);
  nrows = 1;

  gtk_box_pack_start(GTK_BOX(container),table,false,false,0);
}
WidgetPanel::WidgetPanel(map<std::string, CEBL::Param> params)
{
  container = gtk_vbox_new(false,0);
  table = gtk_table_new(1,3,false);
  nrows = 1;

  gtk_box_pack_start(GTK_BOX(container),table,false,false,0);
  createByParams(params);
}

WidgetPanel::~WidgetPanel()
{

}

//adds a string widget
void WidgetPanel::add(string parameter,
                      string description,
                      string default_value)
{
  CEBL::Param temp(parameter, description,default_value);
  add(temp);
}

//adds a CEBL::Param widget
void WidgetPanel::add(CEBL::Param &param)
{
  //Text stuff that is the same for any data type
  parameters.push_back(param.name);
  descriptions.push_back(param.description);
  GtkWidget *label1 = gtk_label_new(param.name.c_str());
  gtk_label_set_line_wrap(GTK_LABEL(label1),true);
  gtk_widget_set_size_request(label1,100,-1);

  GtkWidget *label2 = gtk_label_new(param.description.c_str());
  gtk_label_set_line_wrap(GTK_LABEL(label2),true);
  gtk_widget_set_size_request(label1,100,-1);

  GtkWidget *descript_align = gtk_alignment_new(0,0,1,1);
  gtk_container_add(GTK_CONTAINER(descript_align), label2);

  //Create widget based on data type
  GtkWidget *value;

  //boolean
  if(param==PARAM_BOOLEAN)
    {
      value = gtk_check_button_new();
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(value),param.getBool());
    }
  //integer
  else if(param==PARAM_INTEGER)
    {
      value = gtk_spin_button_new_with_range(param.getMin(),
                                             param.getMax(),
                                             param.getStep());
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(value),param.getInt());

    }
  //double
  else if(param==PARAM_DOUBLE)
    {
      value = gtk_spin_button_new_with_range(param.getMin(),
                                             param.getMax(),
                                             param.getStep());
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(value),param.getDouble());
    }
  //string
  else if(param==PARAM_STRING)
    {
      value = gtk_entry_new();
      gtk_entry_set_text(GTK_ENTRY(value),param.getString().c_str());
    }
  else
    {
      value = gtk_entry_new();
      std::cerr << "No Param Type Identified";
    }

  parameter_widgets.push_back(label1);
  description_widgets.push_back(label2);
  value_widgets.push_back(value);

  //add to table
  gtk_table_resize(GTK_TABLE(table),nrows++,3);
  gtk_table_attach(GTK_TABLE(table)
                   ,label1
                   ,0,1,nrows,nrows+1,
                   GTK_SHRINK,
                   GTK_SHRINK,
                   10,0);

  //GtkWidget *align = gtk_alignment_new(0,0,1,1);
  gtk_table_attach(GTK_TABLE(table)
                   ,value
                   ,1,2,nrows,nrows+1,
                   GTK_SHRINK,
                   GTK_SHRINK,
                   5,0);
  gtk_table_attach(GTK_TABLE(table)
                   ,descript_align
                   ,2,3,nrows,nrows+1,
                   GTK_SHRINK,
                   GTK_SHRINK,
                   10,0);

}

void WidgetPanel::createByParams(map<std::string, CEBL::Param> params)
{
  this->params = params;
  map<std::string, CEBL::Param>::iterator it;
  for(it = params.begin(); it!=params.end(); ++it)
    {
      add(it->second);
    }
}


map<std::string, CEBL::Param> WidgetPanel::getParams()
{
  GtkWidget *widget;
  map<std::string, CEBL::Param>::iterator it;
  int i;
  for(it = params.begin(), i = 0; it!=params.end(); ++it,++i)
    {
      widget = getWidget(i);
      if((it->second)==PARAM_BOOLEAN)
        {
          (it->second).setBool(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
        }
      else if((it->second)==PARAM_INTEGER)
        {
          (it->second).setInt(int(gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget))));
        }
      else if((it->second)==PARAM_DOUBLE)
        {
          (it->second).setDouble(gtk_spin_button_get_value(GTK_SPIN_BUTTON(widget)));
        }
      else if((it->second)==PARAM_STRING)
        {
          (it->second).setString(gtk_entry_get_text(GTK_ENTRY(widget)));
        }
    }
  return params;
}



//return a widget number
GtkWidget *WidgetPanel::getWidget(int i)
{
  return value_widgets.at(i);
}

