/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * WidgetPanel.hpp
 * \author Jeshua Bratman
 *
 * Utility to create a table of widgets
 */



#ifndef WIDGETPANEL_H
#define WIDGETPANEL_H

#include "../CEBLIncludes.hpp"
#include <gtk/gtk.h>
#include "../Param.hpp"
#include <vector>
#include <map>
#include <string>


class WidgetPanel
{
 private:
  std::vector <std::string> parameters;
  std::vector <std::string> descriptions;
  std::vector <GtkWidget*> value_widgets;
  std::vector <GtkWidget*> parameter_widgets;
  std::vector <GtkWidget*> description_widgets;
  std::map <std::string, CEBL::Param> params;
  int number;
  GtkWidget *table;
  GtkWidget *container;
  int nrows;

  //create widget panel by map of params
  void createByParams(std::map<std::string, CEBL::Param> params);

 public:
  WidgetPanel();
  //! Construct widget panel from a map of CEBL::Param
  WidgetPanel(std::map<std::string, CEBL::Param> params);
  ~WidgetPanel();

  //! Add a text input box to the widget panel.
  void add(std::string parameter, std::string description, std::string default_value);

  //! Add a CEBL::Param input to the panel.
  void add(CEBL::Param &);

  //! Return widget container.
  GtkWidget *getContainer() { return container; };

  //! Get individual widget from panel.
  GtkWidget *getWidget(int i);

  //! Get map of params representing current state of the panel.
  map<std::string, CEBL::Param> getParams();
};

#endif

