/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * WidgetUtils.hpp
 * \author Jeshua Bratman
 *
 * Contains various widget functions such as alert and confirm boxes.
 */


#ifndef WIDGETUTILS_H
#define WIDGETUTILS_H

//include gtk headers
#include <gtk/gtk.h>

#include <string>
using std::string;

class WidgetUtils
{
private:
  static GtkWidget *main_window;


  //wait box variables
  static gint pulseProgressBar(gpointer);
  static void CB_waitBoxCancel(GtkWidget*, gpointer);
  static void waitBox(bool, const char *, bool show_progress_bar = true);
  static bool wait_box_open;
  static GtkWidget *wait_box_btn_cancel;
  static GtkWidget *wait_box_label_text;
  static bool wait_box_cancelled;
  static double wait_box_progress;

public:
  // Set up widget utilities
  static void setMainWindow(GtkWidget *mw) { WidgetUtils::main_window = mw; }

  static GtkWidget* getMainWindow() { return(main_window); }

  //! Show an alert
  static void Alert(const char * title, const char * text, GtkMessageType type);
  static void Alert(const string, const string, GtkMessageType type);

  //! Show an alert with an info icon
  static void AlertWarning(const char * title, const char * text);
  static void AlertWarning(const string, const string);

  //! Show an alert with an error icon
  static void AlertError(const char * title, const char * text);
  static void AlertError(const string, const string);

  //! Show a confirm and return the response value.
  static bool Confirm(const char * title, const char * text, GtkMessageType type);
  static bool Confirm(const char * title, const char * text);
  static bool Confirm(const string, const string);
  static bool Confirm(const string, const string, GtkMessageType type);

  //! Lock the gui and wait.
  static void waitBoxShow(const char * text,bool progress = true);
  static void waitBoxSetText(const char * text);
  static void waitBoxSetCancelAvailable(bool available);
  static void waitBoxHide();
  static bool waitBoxCancelled();
  static void waitBoxSetProgress(double percent);


  //! select a file to save to
  static string selectSaveFile(string extension = "");

  //! select a file to load from
  static string selectLoadFile();
};
#endif


