/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/



/*!
 * \class X11Controller
 * \author Jeshua Bratman
 *
 * Various X11 functions wrapped in easy to use interfaces.
 */


#ifndef X11CONTROLLER_H
#define X11CONTROLLER_H

#include <X11/Xlib.h>

class X11Controller
{
private:
  Display *display;
  Window getWindowByNameRecursive(Window root,
                                  const char *search_name,
                                  int level);
  int msleep(unsigned long milisec);
  int randrange(int low, int high);
  void pause();
  KeyCode getKeyCodeFromString(const char *key);


public:
  X11Controller();
  ~X11Controller();

  Window getWindowByName(const char *search_name);
  bool getCursorXYAbsolute(int *x, int *y);
  bool getWindowXYAbsolute(Window window, int *x, int *y);
  bool getWindowSize(Window window, int *width, int *height);
  bool moveCursorIntoWindow(Window window);
  bool moveCursorAbsoluteInWindow(Window window, int x, int y);
  bool moveCursorRelative(int x, int y);

  //clicking
  bool buttonPress(unsigned int button);
  bool buttonRelease(unsigned int button);
  bool leftClick(); 
  bool rightClick();
  bool middleClick(); 
  bool doubleClick();

  //keys
  bool keyPress(const char * key);
  bool keyRelease(const char *key);
  bool keySend(const char *key);
  bool stringSend(const char *string);

  bool displayIsOpen() { return display != NULL; }
  void closeDisplay();
};

#endif
