#include <sstream>

#include "CursorPie.hpp"
#include "../X11Controller.hpp"
#include "../../TextUtils.hpp"

CursorPie::CursorPie() : PieInterface()
{
  for(int i=0;i<10;i++)
    {
      xmove.push_back(5);
      ymove.push_back(5);
    }
}


void CursorPie::selectClass(int c)
{
  if(c == -1)
    pie_set_bars_visible(pie_menu, false);
  else
    {
      pie_set_bars_visible(pie_menu, true);
      pie_select_class(pie_menu, c);
      selectPie(c);
    }
}

void CursorPie::selectPie(int c)
{
  X11Controller x;

  if(!x.displayIsOpen())
    return;

  if(xmove.size() > unsigned(c)
     && ymove.size() > unsigned(c))
    {
      x.moveCursorRelative(xmove[c],ymove[c]);
    }
}

//------------------------------------------------------------


std::map<std::string,CEBL::Param> CursorPie::getParamsList()
{
  std::map<std::string,CEBL::Param> params;
  for(int i=0;i<num_classes;i++)
    {
      int current = 0;
      if(xmove.size() > unsigned(i))
        current = this->xmove[i];

      CEBL::Param temp("Class " + TextUtils::IntToString(i) + " X:",
                     " Amount to move cursor in X direction.",
                     current);
      std::stringstream ss1;
      ss1 << "x" << i;
      params[ss1.str()] = temp;

      //----------------------------------------
      //y
      current = 0;
      if(ymove.size() > unsigned(i))
        current = this->ymove[i];

      CEBL::Param temp2("Class " + TextUtils::IntToString(i) + " Y: ",
                      " Amount to move cursor in Y direction.",
                      current);
      std::stringstream ss2;
      ss2 << "x" << i;
      params[ss2.str()] = temp2;


    }
  return params;
}
void CursorPie::setParamsList( std::map<std::string,CEBL::Param> p)
{
  this->xmove.resize(0);
  this->ymove.resize(0);
  map<std::string, CEBL::Param>::iterator it;
  for(it = p.begin(); it!=p.end(); ++it)
    {
      this->xmove.push_back(it->second.getInt());
      ++it;
      this->ymove.push_back(it->second.getInt());
    }

}
