/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* CursorPie.hpp
 * \author Jeshua Bratman
 *
 * Simple cursor interface for CEBL.
 */

#ifndef CURSORPIE_H
#define CURSORPIE_H
#include "PieInterface.hpp"


class CursorPie : public PieInterface
{
 private:
  std::vector<int> xmove;  
  std::vector<int> ymove;

  void selectPie(int c);

 public:
  CursorPie();
  void selectClass(int);
  void setParamsList(std::map<std::string,CEBL::Param>);
  std::map<std::string,CEBL::Param> getParamsList();
};

#endif
