/* EEGInterface.cpp
 * \author Jeshua Bratman
 *
 * Training and classifying graphical interface for CEBL.
 */

#include "EEGInterface.hpp"


//! Constructor. Creates gtk container.
EEGInterface::EEGInterface()
{
  container = gtk_vbox_new(FALSE,0);
  g_object_ref(container);
  gtk_widget_show_all(container);
  this->setWidgetContainer(container);
  bg_red = 65535;
  bg_green = 65535;
  bg_blue = 65535;
}
EEGInterface::~EEGInterface()
{
  g_object_unref(container);
}
//--------------------------------------------------
//private methods

//!  packStart adds a widget to the interface container at the beginning
void EEGInterface::packStart(GtkWidget *widget, bool expand, bool fill, int padding)
{
  gtk_box_pack_start(GTK_BOX(container), widget, expand, fill, padding);
  gtk_widget_show_all(widget);
}
void EEGInterface::packStart(GtkWidget *widget)
{
  packStart(widget, false, false, 2);
}
//! packEnd adds a widget to the interface container at the end.
void EEGInterface::packEnd(GtkWidget *widget, bool expand, bool fill, int padding)
{
  gtk_box_pack_end(GTK_BOX(container), widget, expand, fill, padding);
  gtk_widget_show_all(widget);
}
void EEGInterface::packEnd(GtkWidget *widget)
{
  packEnd(widget, false, false, 2);
}

