/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* EEGInterface.hpp
 * \author Jeshua Bratman
 *
 * Training and classifying graphical interface for CEBL.
 */

#ifndef EEGINTERFACE_H
#define EEGINTERFACE_H
#include <gtk/gtk.h>
#include "../../Param.hpp"
#include "../WidgetPanel.hpp"
#include "../CEBLGtkWidgetDetachable.hpp"

//include std headers
#include <vector>
using namespace std;

class EEGInterface : public CEBLGtkWidgetDetachable
{
 protected:

  //container to hold interface gui
  GtkWidget *container;

  //configuration widgets
  WidgetPanel *configuration_panel;
  bool configuration_window_open;

  //private methods to insert widgets into the interface
  void packStart(GtkWidget *, bool expland, bool fill, int padding);
  void packStart(GtkWidget *);
  void packEnd(GtkWidget *, bool expand, bool fill, int padding);
  void packEnd(GtkWidget *);

  //number of classes selected
  int num_classes;
  bool train_mode;

  //background colors
  unsigned int bg_red,bg_green,bg_blue;

 public:

  //! constructors / destructors
  EEGInterface();
  virtual ~EEGInterface();

  //! get list of parameters
  virtual std::map<std::string, CEBL::Param> getParamsList()
    {
      std::map<std::string, CEBL::Param> params;
      return params;
    }
  //! set values for parameter list
  virtual void setParamsList(std::map<std::string, CEBL::Param> param){}

  //! set number of classes
  virtual void setNumClasses(int n) { num_classes = n; };

  //! set the background color of the interface
  //RGB should each be 32 bit unsigned integers
  virtual void setBGColor(unsigned int red, unsigned int green, unsigned int blue){bg_red=red;bg_green=green;bg_blue=blue;}

  //! set the class currently being trained
  virtual void selectTrainingClass(int n) = 0;

  //! select class and reset 
  virtual void selectClass(int c) = 0;

  //! move bars based on proportions for each class
  virtual void setClassProportions(std::vector<double> proportions) = 0;

  //! set labels for each class
  virtual void setClassLabels(std::vector<std::string>) = 0;

  //! set mode to train
  virtual void setTrainMode() { train_mode = true; }

  //! set mode to use
  virtual void setUseMode() { train_mode = false; }

};

#endif
