/* KeyboardPie.cpp
 * \author Jeshua Bratman
 *
 * Keyboard interface for CEBL
 */


#include "KeyboardPie.hpp"
#include "../X11Controller.hpp"
#include <iostream>

KeyboardPie::KeyboardPie() : PieInterface()
{
  //init everything
  init();

  //create vectors
  alphabet.resize(26);
  for(unsigned int i=0; i<alphabet.size();i++)
    {
      char letter = char(i+0x41);
      alphabet[i] = letter;
    }
  punctuation.resize(5);
  punctuation[0] = ".";
  punctuation[1] = ",";
  punctuation[2] = "?";
  punctuation[3] = "!";
  punctuation[4] = "\"";

  special.resize(3);
  special[0] = "[BACKSPACE]";
  special_keys[special[0]] = "BackSpace";
  special[1] = "[ENTER]";
  special_keys[special[1]] = "Return";
  special[2] = "[SPACE]";
  special_keys[special[2]] = "space";

  back_level.resize(1);
  back_level[0] = "BACK";

  //testing
  classes.push_back(0);
  classes.push_back(1);
  classes.push_back(0);
  classes.push_back(2);
  classes.push_back(2);
  classes.push_back(2);
  index = 0;

  GtkWidget *hbox_type = gtk_hbox_new(false,0);
  typing_box = gtk_entry_new();
  check_send_keys = gtk_check_button_new_with_label("Send Keyboard Events?");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_send_keys),true);
  send_keys = true;

  gtk_widget_set_size_request(typing_box,300,20);
  gtk_box_pack_start(GTK_BOX(hbox_type),gtk_label_new("Typed Characters: "),false, false, 0);
  gtk_box_pack_start(GTK_BOX(hbox_type),typing_box,false, false, 0);
  gtk_box_pack_end(GTK_BOX(hbox_type),check_send_keys,false, false, 0);
  packStart(hbox_type);
}

void KeyboardPie::init()
{
  use_special = false;

  //initial mode
  mode = SELECT_MODE;
}

void KeyboardPie::setNumClasses(int n)
{
  num_classes = n;
  pie_set_segments(pie_menu,n);
  updateNames();
}

void KeyboardPie::updateNames()
{
  if(num_classes > 2)
    use_special = true;
  else
    use_special = false;


  //select mode shows all sets of keys
  if(mode==SELECT_MODE)
    {

      if(use_special)
        {
          //set first class to special functions
          current_labels[0] = special;
          split(alphabet,1,num_classes);
        }
      else
        {
         split(alphabet,0,num_classes);
        }
    }
  else
    {
      if(use_special)
        {
          current_labels[0] = back_level;
          split(key_pool,1,num_classes);
        }
      else
        {
          split(key_pool,0,num_classes);
        }
    }
  //create labels vector
  vector<string> labels;
  labels.resize(num_classes);
  for(unsigned int i=0; i<unsigned(num_classes); i++)
    {
      labels[i] = "";
      if(current_labels[i].size() > 8)
        {
          labels[i] = current_labels[i][0] + " - "
            +current_labels[i][current_labels[i].size()-1];
        }
      else
        {
          for(unsigned int j=0; j<current_labels[i].size(); j++)
            {
              if(i != 1
                 && mode!=PUNCTUATION_MODE
                 && !(i==0 && mode!=SELECT_MODE && use_special==false)
                 && (j+1) != current_labels[i].size())
                labels[i] += current_labels[i][j] + ", ";
              else
                labels[i] += current_labels[i][j] + " ";
            }
        }
    }
  pie_set_secondary_labels(pie_menu, labels);
}

void KeyboardPie::split(vector<string> keys, int start, int end)
{
  int num = end-start;
  if(num < 1)
    return;

  int count = 0;
  int i = 0;
  for(int cls=start; cls < end; cls++)
    {
      current_labels[cls].clear();
      current_labels[cls].resize(0);
      i++;
      for(unsigned int key=count; key<keys.size(); key++)
        {
          if(count >= int(i * keys.size()/num))
            break;
          current_labels[cls].push_back(keys[key]);
          count++;
        }
    }
}

void KeyboardPie::selectClass(int c)
{

  if(c == -1)
    {
      pie_set_bars_visible(pie_menu, false);
      init();
      updateNames();
    }
  else
    {
      //for testing purposes
      //c = classes[index];;
      //c = rand() % num_classes;
      if(mode!=SELECT_MODE && current_labels[c].size() < 1)
        return;

      pie_set_bars_visible(pie_menu, true);
      pie_select_class(pie_menu, c);
      selectPie(c);
    }
}


void KeyboardPie::selectPie(int c)
{
  index++;
  if(unsigned(index) >= classes.size())
    index = 0;
  if(mode == SELECT_MODE)
    {
      if(use_special)
        {
          if(c==0)
            {
              mode = SPECIAL_MODE;
              key_pool = special;
            }
          /*else if(c==1)
            {
              mode = PUNCTUATION_MODE;
              key_pool = punctuation;
              }*/
          else
            {
              mode = ALPHABET_MODE;
              key_pool = current_labels[c];
            }

        }
      else
        {
          /*if(c==1)
            {
              mode = PUNCTUATION_MODE;
              key_pool = punctuation;
            }
            else*/
            {
              mode = ALPHABET_MODE;
              key_pool = current_labels[c];
            }
        }
    }
  else
    {
      if(c!=0 && current_labels[c].size() == 1)
        {
          send_keys = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_send_keys));
          string key = current_labels[c][0];
          if(mode == SPECIAL_MODE)
            {
              key = special_keys[current_labels[c][0]];
            }
          if(send_keys)
            {
              cout << "sending " << key << "\n";
              //send the key to the display
              X11Controller x;
              if(x.displayIsOpen())
                {
                  x.keySend(key.c_str());
                }
            }
          while(!key_pool_stack.empty())
            key_pool_stack.pop();
          mode = SELECT_MODE;
        }
      else
        {
          //if number of classes > 2, c=0 is the back button
          //go back
          if(c == 0 && num_classes > 2)
            {
              if(key_pool_stack.empty())
                {
                  mode = SELECT_MODE;
                }
              else
                {
                  key_pool = key_pool_stack.top();
                  key_pool_stack.pop();
                }
            }
          //select characters from the character pool
          else
            {
              key_pool_stack.push(key_pool);
              key_pool = current_labels[c];
            }
        }
    }
  updateNames();
}


//----------------------------------------
//parameters
std::map<std::string, CEBL::Param> KeyboardPie::getParamsList()
{
  std::map<std::string, CEBL::Param> params;
  return params;
}
void KeyboardPie::setParamsList(std::map<std::string, CEBL::Param> p)
{
}
