/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* KeyboardPie.hpp
 * \author Jeshua Bratman
 *
 * Keyboard interface for CEBL
 */

#ifndef KEYBOARDPIE_H
#define KEYBOARDPIE_H
#include "PieInterface.hpp"
#include <sstream>
#include <map>
#include <stack>
#include <string>

using namespace std;

enum MODE {SELECT_MODE, ALPHABET_MODE, PUNCTUATION_MODE, SPECIAL_MODE};

class KeyboardPie : public PieInterface
{
 private:
  GtkWidget *typing_box;
  GtkWidget *check_send_keys;
  bool send_keys;
  bool use_special;
  MODE mode;

  int index;
  vector<int> classes;
  vector<string> alphabet;
  vector<string> punctuation;
  vector<string> special;
  map<string, string> special_keys;
  vector<string> back_level;
  vector<string> key_pool;
  stack<vector<string> > key_pool_stack;
  map<int, vector<string> > current_labels;

  int top;
  int bottom;

  void split(vector<string>, int, int);
  void selectPie(int c);
  void init();
  void updateNames();

 public:
  KeyboardPie();

  //interface functions
  void setNumClasses(int);
  void selectClass(int);
  void setParamsList(std::map<std::string, CEBL::Param>);
  std::map<std::string, CEBL::Param> getParamsList();
};

#endif
