/* PieInterface.cpp
 * \author Jeshua Bratman
 *
 * Simple pie menu interface for CEBL.
 */

#include "PieInterface.hpp"

PieInterface::PieInterface()
{
  pie_menu = pie_menu_new();
  packStart(pie_menu,true,true,2);
  pie_set_bg(pie_menu, bg_red,bg_green,bg_blue);
  bar_growth = 0.1;
  setNumClasses(2);
}

PieInterface::~PieInterface()
{

}

void PieInterface::setNumClasses(int n)
{
  num_classes = n;
  pie_set_segments(pie_menu,n);
}

void PieInterface::selectTrainingClass(int n)
{
  pie_set_bars_visible(pie_menu, false);
  pie_set_selected(pie_menu, n);
}

void PieInterface::selectClass(int c)
{
  if(c == -1)
    pie_set_bars_visible(pie_menu, false);
  else
    pie_select_class(pie_menu, c);
}

void PieInterface::setClassProportions(std::vector<double> proportions)
{  
  pie_set_bars_visible(pie_menu, true);
  pie_set_class_proportions(pie_menu,proportions);
}


void PieInterface::setClassLabels(std::vector<std::string> labels)
{
  pie_set_labels(pie_menu, labels);
}


void PieInterface::setBGColor(unsigned int red, unsigned int green, unsigned int blue)
{
  bg_red=red;
  bg_green=green;
  bg_blue=blue;
  pie_set_bg(pie_menu, bg_red, bg_green, bg_blue);
}

void PieInterface::setTrainMode()
{
  pie_set_train_mode(pie_menu);
  train_mode = true;
}

void PieInterface::setUseMode()
{
  pie_set_use_mode(pie_menu);
  train_mode = false;
}


//------------------------------------------------------------


std::map<std::string, CEBL::Param> PieInterface::getParamsList()
{
  std::map<std::string,CEBL::Param> params;
  return params;
}
void PieInterface::setParamsList( std::map<std::string, CEBL::Param> p)
{

}



