/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* PieInterface.hpp
 * \author Jeshua Bratman
 *
 * Simple pie menu interface for CEBL. Can be inherited from.
 */

#ifndef SIMPLEPIE_H
#define SIMPLEPIE_H
#include "PieMenu.hpp"
#include "EEGInterface.hpp"

class PieInterface : public EEGInterface
{
 protected:
  GtkWidget *pie_menu;
  double bar_growth;

 public:
  PieInterface();
  virtual ~PieInterface();
  virtual void selectTrainingClass(int);
  virtual void setNumClasses(int);
  virtual void selectClass(int);
  virtual void setClassProportions(std::vector<double> proportions);
  virtual void setClassLabels(std::vector<std::string> labels);
  virtual void setBGColor(unsigned int red, unsigned int green, unsigned int blue);
  virtual void setParamsList( std::map<std::string, CEBL::Param> params);
  virtual std::map<std::string, CEBL::Param> getParamsList();
  virtual void setTrainMode();
  virtual void setUseMode();
};

#endif
