/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* PieMenu.hpp
 * \author Jeshua Bratman
 *
 * Pie menu widget for GTK. Used by CEBL pie interfaces.
 */

#ifndef PIE_H
#define PIE_H

#include <gtk/gtk.h>
#include <vector>
#include <string>

G_BEGIN_DECLS

#define PIE_MENU_TYPE        	    (pie_menu_get_type())
#define PIE_MENU(obj)        	    (G_TYPE_CHECK_INSTANCE_CAST ((obj), PIE_MENU_TYPE, PieMenu))
#define PIE_MENU_CLASS(obj)            (G_TYPE_CHECK_CLASS_CAST ((obj), PIE_MENU, PieMenuClass))
#define PIE_IS_PIE_MENU(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PIE_MENU_TYPE))
#define PIE_IS_PIE_MENU_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE ((obj), PIE_MENU_TYPE))
#define PIE_MENU_GET_CLASS            (G_TYPE_INSTANCE_GET_CLASS ((obj), PIE_MENU_TYPE, PieMenuClass))

typedef struct _PieMenu PieMenu;
typedef struct _PieMenuClass PieMenuClass;

struct _PieMenu
{
  GtkDrawingArea parent;
};

struct _PieMenuClass
{
  GtkDrawingAreaClass parent_class;
};



GtkWidget *pie_menu_new (void);
GType pie_menu_get_type (void);

G_END_DECLS

void pie_set_segments(GtkWidget *pie, int segments);
void pie_set_selected(GtkWidget *pie, int segment);
void pie_set_bars_visible(GtkWidget *pie, bool val);
void pie_set_labels(GtkWidget *pie, std::vector<std::string> labels);
void pie_set_secondary_labels(GtkWidget *pie, std::vector<std::string> labels);
void pie_set_train_mode(GtkWidget *pie);
void pie_set_use_mode(GtkWidget *pie);
void pie_set_bg(GtkWidget *pie, unsigned int red, unsigned int green, unsigned int blue);

void pie_set_class_proportions(GtkWidget *pie,std::vector<double> proportions);
void pie_select_class(GtkWidget *pie,int c);

#endif
