/* RobotPie.cpp
 * \author Jeshua Bratman
 *
 * Simple keyboard interface for CEBL.
 * Types the name of a class when it is selected.
 */


#include "RobotPie.hpp"
#include "../X11Controller.hpp"
#include "../../TextUtils.hpp"


RobotPie::RobotPie() : PieInterface()
{

}


void RobotPie::selectClass(int c)
{
  if(c == -1)
    pie_set_bars_visible(pie_menu, false);
  else
    {
      pie_set_bars_visible(pie_menu, true);
      pie_select_class(pie_menu, c);
      selectPie(c);
    }
}

void RobotPie::selectPie(int c)
{
  X11Controller x;

  if(!x.displayIsOpen())
    return;

  if(commands.size() > unsigned(c))
    {
      x.stringSend(commands[c].c_str());
    }
}

//------------------------------------------------------------


std::map<std::string,CEBL::Param> RobotPie::getParamsList()
{
  std::map<std::string,CEBL::Param> params;
  for(int i=0;i<num_classes;i++)
    {
      string current = "";
      if(commands.size() > unsigned(i))
        current = this->commands[i];

      CEBL::Param temp("Command for " + TextUtils::IntToString(i),
        	     "text to type when this class is selected",
        	     current);

      params[current] = temp;
    }
  return params;
}
void RobotPie::setParamsList(std::map<std::string,CEBL::Param> p)
{
  map<std::string, CEBL::Param>::iterator it;
  for(it = p.begin(); it!=p.end(); ++it)
    {
      this->commands.push_back(it->second.getString());
    }
  pie_set_secondary_labels(pie_menu,commands);
}
