/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/* RobotPie.hpp
 * \author Jeshua Bratman
 *
 * Simple keyboard interface for CEBL.
 * Types the name of a class when it is selected.
 */

#ifndef ROBOTPIE_H
#define ROBOTPIE_H
#include "PieInterface.hpp"

class RobotPie : public PieInterface
{
 private:
  std::vector<std::string> commands;
  void selectPie(int c);
 public:
  RobotPie();
  void selectClass(int);
  void setParamsList(std::map<std::string,CEBL::Param>);
  std::map<std::string,CEBL::Param> getParamsList();
};

#endif
