/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


/*! CEBLSerialization.hpp
 * Author: Jeshua Bratman
 * 
 * Contains various functions to serialize objects to strings.
 * Does not use boost serialization due to issues with calling these
 * functions from shared libraries.
 */

#ifndef CEBLSERIALIZATION_H
#define CEBLSERIALIZATION_H

#include <vector>
#include "cppR/cppR.hpp"
#include <string>
#include <sstream>

namespace CEBL 
{

  typedef string SerializedObject;

  using std::string;
  using std::stringstream;

  //----------------------------------------------------------------------
  //PRIMITIVES

  template<typename T>
  string serialize(const T& val)
  {
    stringstream ss;
    ss << val;
    return ss.str();
  }

  template<typename T>
  T& deserialize(stringstream& ss, T& output)
  {
    T temp;
    ss >> temp;
    output = temp;
    return output;
  }


  //----------------------------------------------------------------------
  //STL CLASSES

  template<typename T>
  string serialize(const std::vector<T>& val)
  {
    stringstream ss;
    ss << val.size() << " ";
    for(unsigned i=0; i<val.size(); i++)
      {
        ss << serialize(val[i]) << "  ";
      }
    return ss.str();
  }

  template<typename T>
  std::vector<T>& deserialize(stringstream& ss, std::vector<T> & output)
  {
    std::vector<T> ret;
    int size;
    ss >> size;
    ret.resize(size);

    for(unsigned i=0; i<ret.size(); i++)
      {
        T temp;
        deserialize(ss,temp);
        ret[i] = temp;
      }
    output = ret;

    return output;
  }

  //----------------------------------------------------------------------

  /*! Create stringstream from str and calls the stringstream deserialize
    \param str serialized string
    \param output outputs result to this object
    
    \return returns stringstream 
  */
  template<typename T>
  string deserialize(const string& str, T& output)
  {
    stringstream ss;
    ss << str;
    deserialize(ss,output);
    return ss.str();
  }
}

#endif
