/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! \class ChannelsConfig
 *  \author Jeshua Bratman
 *
 * Channel configuration for CEBL. Contains setting for each electrode, and
 * allows saving and loading of these settings.
 */

#ifndef CHANNELSCONFIG_H
#define CHANNELSCONFIG_H

//forward declarations
class CEBLModel;
using std::string;

class ChannelsConfig
{
private:
  CEBLModel * model;

  string config_filename;
  int max_num_channels;

  vector<string> channels_names;
  vector<bool> channels_enabled;
  vector<bool> channels_reference;


  /*! Update configuration from input stream.
    \param ifs stream to read from

    \return success
  */
  bool parseConfigFromStream(std::istream &ifs);

  /*! Saves full configuration to an output stream.
    \param ofs stream to save config to

    \return success
  */
  bool saveConfigToStream(std::ostream &ofs);

public:
  ChannelsConfig(CEBLModel *model);
  ~ChannelsConfig();


  // getters used by model
  string getCurrentFilename();
  string getElectrodeName(int);
  bool getElectrodeReference(int);
  bool getElectrodeEnabled(int);
  int getMaxNumChannels();
  std::vector<string> getEnabledNames();
  int getNumEnabled();
  string getConfigurationString();

  // setters used by model
  void loadFile(string filename);
  void saveFile(string filename);
  void setElectrodeName(int electrode, string name);
  void setElectrodeReference(int electrode, bool enabled);
  void setElectrodeEnabled(int electrode, bool enabled);
  void setConfigurationFromString(string config);


  //other getters
  /*! Returns vector of flags corrosponding to each channel
    indicating whether they are enabled or not.

    \return vector of enabled flags
  */
  vector<bool> getEnabledMask() { return channels_enabled; }

};


#endif
