/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! \class ClassifiersConfig
 *  \author Jeshua Bratman
 *
 * Finds, loads, and creates classifiers from classifiers shared libraries.
 * Also provides methods to train and use these classifiers.
 */

#ifndef CLASSIFIERSCONFIG_H
#define CLASSIFIERSCONFIG_H

#include "PluginLoader.hpp"
#include "Classifier.hpp"
#include "SessionManager.hpp"
using namespace CEBL;

//std includes
#include <vector>
using namespace std;

//forward declarations
class CEBLModel;

class ClassifiersConfig
{
private:
  //make session manager a friend
  friend class SessionManager;

  CEBLModel *model;

  //classifiers plugins
  PluginLoader<Classifier> * plugin_loader;
  PluginLoader<Classifier> * getPluginLoader() { return plugin_loader; }

  //selected classifier
  string selected_classifier;

  //training
  bool is_training;
  string currently_training_classifier;

public:
  ClassifiersConfig(CEBLModel *);
  ~ClassifiersConfig();

  //GETTING OPERATIONS
  std::vector<string> getNameList();
  std::vector<string> getPathList();
  bool isTrained(string classifier = "");
  string getSelected();
  std::map<std::string, CEBL::Param> getParams(string classifier = "");
  bool getUseProbs();
  std::vector<std::vector<double> > getLastProbs();
  int getTrainedClasses();
  int getTrainedLags();

  //SETTING OPERATIONS
  void reset(CEBL::Param, string classifier="");
  void setSelected(string classifier);
  void train(EEGTrainingData &training_data, string classifier = "");
  void haltTrain();
  void setParams(std::map<std::string, CEBL::Param> params, string classifier);
  void setUseProbs(bool flag);

  //USE CLASSIFIER
  ublas::vector<int> use(EEGData &data);

};

#endif

