/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! \class DataIO
 * \author Jeshua Bratman
 *
 * Various functons to save and load eeg data.
 */


#ifndef DATAIO_HPP
#define DATAIO_HPP

#include <vector>
using namespace std;

#include <cppR/cppR.hpp>
#include "EEGTrainingData.hpp"


namespace DataIO
{
  /*! Saves an EEGTrainingData object to a file. 
   */
  void saveTrainingDataToFile(const EEGTrainingData &, string filename);

  /*! Saves a filtered and unfiltered training data session to a file. 
    \param unfiltered_data 
    \param filename 
    \param filtered_data 
    \param filter_lags 
    \param filter_removed_components 
    \param filter_matrix 
  */
  void saveTrainingSessionToFile(const EEGTrainingData &unfiltered_data,
                                 string filename,
                                 const EEGTrainingData &filtered_data,
                                 int filter_lags,
                                 std::vector<int> filter_removed_components,
                                 ublas::matrix<double> filter_matrix);


  /*! Loads an EEGTrainingData object from a file. 
    \param filename 
    
    \return 
  */
  EEGTrainingData loadTrainingDataFromFile(string filename);

  /*! Creates a temporary directory. 
    
    \return 
  */
  std::string createTempDir();

  /*! Removes a temporary directory.. 
    \param dir 
  */
  void removeTempDir(std::string dir);
};

#endif
