#include <cppR/cppR.hpp>
using namespace cppR;

#include "DataProcess.hpp"
#include "../CEBLModel.hpp"
#include "ChannelsConfig.hpp"
#include "FilterConfig.hpp"


//----------------------------------------------------------------------
// CONSTRUCTORS / DESTRUCTORS


DataProcess::DataProcess(CEBLModel * model)
{
  this->model = model;
  this->remove_disabled = true;
  this->reference = false;
  this->filter = false;
}

DataProcess::~DataProcess()
{}



//----------------------------------------------------------------------
// PROCESS DATA

EEGTrainingData DataProcess::process(EEGTrainingData & data)
{
  EEGTrainingData processed_data;
  EEGData temp;
  processed_data.reserve(data.numClasses(),data.numSequences());
  for(int cls = 0; cls < data.numClasses(); cls++)
    {
      for(int seq = 0; seq < data.numSequences(cls); seq++)
        {
          temp = data.get(cls,seq);
          temp = process(temp);
          processed_data.set(cls,seq,temp);
        }
    }
  return processed_data;
}

EEGData & DataProcess::process(EEGData & data)
{
  return process(data, remove_disabled, reference, filter);
}

EEGData & DataProcess::process(EEGData &data, 
                               bool remove_disabled,
                               bool reference,
                               bool filter)
{
  if(data.size1()==0 || data.size2()==0)
    return data;

  if(remove_disabled)
    {
      //if the number of channels in data is equal to max,
      // then we can simply mask off rows
      if(data.nrow() == model->getChannelsConfig()->getMaxNumChannels())
        {
          data = cppR::rowMask(data.getMatrix(),
                               model->getChannelsConfig()->getEnabledMask());
        }
      //otherwise just return the first n rows
      // where n is the number of enabled channels
      else
        {
          int num_rows = model->getChannelsConfig()->getNumEnabled();
          //make sure we aren't trying to select too many rows
          if(data.size1() < num_rows)
            num_rows = data.size1();
          data = EEGData(cppR::submatrix(data.getMatrix(),0,num_rows-1,0,0));
        }
    }

  if(filter)
    {

      //check if filter is even trained
      if(model->getFilterConfig()->isTrained())
        {
          //do the filtering
          try
            {
              data = model->getFilterConfig()->apply(data);
            }
          catch(const char *e)
            {
              throw DataProcessException("Failed to apply filter.");
            }
        }
      else
        {
          throw DataProcessException("Filter cannot be applied because the"
                                     + string(" ") + 
                                     "selected filter has not been trained.");
        }
    }

  return data;
}




