/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * \class DataProcess
 * \author Jeshua Bratman
 *
 * Class to process data based on configurations.
 */


#ifndef DATAPROCESS_H
#define DATAPROCESS_H

#include "EEGTrainingData.hpp"
#include "EEGData.hpp"

//forward declarations
class CEBLModel;

class DataProcess
{
private:
  CEBLModel * model;

  //options to process
  bool remove_disabled;
  bool filter;
  bool reference;

public:
  DataProcess(CEBLModel * model);
  ~DataProcess();

  EEGTrainingData process(EEGTrainingData & data);
  EEGData & process(EEGData & data);
  EEGData & process(EEGData & data,
                    bool remove_disabled, bool reference, bool filter);

  //SETTERS
  void setRemoveEnabled(bool r) { remove_disabled = r; }
  void setFilterEnabled(bool f) { filter = f; }
  void setReferenceEnabled(bool r) { reference = r; }

  //GETTERS
  bool getRemoveEnabled() { return remove_disabled; }
  bool getFilterEnabled() { return filter; }
  bool getReferenceEnabled() { return reference; }

};


#endif
