/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! 
 * \class DataSource
 * \author Jeshua Bratman
 *
 * Class to deal with data recording and output.
 */



#ifndef DATASOURCEMODEL_H
#define DATASOURCEMODEL_H

#include "../CEBLIncludes.hpp"
#include "SessionManager.hpp"
#include "EEGData.hpp"

//forward declarations
class CEBLModel;
class EEGDataStream;


class DataSource
{
private:
  //make SessionManager a friend
  friend class SessionManager;

  std::vector<string> source_names;
  int selected_source;
  int active_stream_type;

  //this flag indicates if a second copy of data
  // should be stored as it is read out
  bool data_store_flag;

  //this is a data buffer used ONLY if data_store flag is set
  EEGData data_buffer;

  EEGDataStream *data_stream;
  CEBLModel *model;

  /*! Create the data stream object based on selected source. 
   */
  void createDataStream();

  /*! Set the data buffer. 
    \param buffer 
  */
  void setDataBuffer(EEGData buffer)
  {
    this->data_buffer = buffer;
  }

public:
  DataSource(CEBLModel *model);
  ~DataSource();

  //GETTING OPERATIONS
  EEGData read(int samples);
  EEGData readAll();
  int samplesAvailable();
  std::vector<string> getSources() { return source_names; }
  int getSource() { return selected_source; }
  bool sourceReady();
  bool isStarted();
  bool getStoreFlag();
  int getStoreNumSamples();
  EEGData getStoredData();

  //SETTING OPERATIONS
  void clearStoredData();
  void setStoreFlag(bool flag);
  void setSource(int source);
  void setSource(string source);
  void clearSamples();

  void start();
  void stop();

};


#endif
