#include <algorithm>
using namespace std;

#include "DecisionConfig.hpp"
#include "../CEBLModel.hpp"


//----------------------------------------------------------------------
// CONSTRUCTORS / DESTRUCTORS


DecisionConfig::DecisionConfig(CEBLModel *model)
{
  this->model = model;
  this->plugin_loader = new PluginLoader<Decision>;
  this->selected_decision = "";
  std::vector<string> paths = model->preferencesGetPaths();
  for(unsigned int i=0; i<paths.size();i++)
    {
      string path = paths[i]+"/plugins/decision/";
      try
        {
          plugin_loader->loadDir(path.c_str());
        } catch(FileException & e)
        {
          cerr << e.what() << "\n";
          //if there were exceptions, just continue
          continue;
        }
    }
  if (plugin_loader->getNames().size() > 0)
    {
      this->selected_decision = this->getNameList().at(0);
    }
}

DecisionConfig::~DecisionConfig()
{
  delete plugin_loader;
}

//----------------------------------------------------------------------
//GETTING OPERATIONS

//special sort to put MSPRT at the top
bool decisionSort(string i, string j)
{
  if(i == "MSPRT")
    return true;
  else
    return (i<j);
}

std::vector<string> DecisionConfig::getNameList()
{
  std::vector<string> names = plugin_loader->getNames();
  sort(names.begin(),names.end(),decisionSort);
  return names;
}

std::vector<string> DecisionConfig::getPathList()
{
  return plugin_loader->getPaths();
}

string DecisionConfig::getSelected()
{
  return this->selected_decision;
}

std::map<std::string, CEBL::Param> DecisionConfig::getParams(string decision)
{
  if(decision=="")
    decision = selected_decision;
  try
    {
      return plugin_loader->getPlugin(selected_decision)->getParamsList();
    }
  catch(...)
    {
      throw PluginException("Failed to get parameter list for decision: " 
                            + selected_decision);
    }
}

//----------------------------------------------------------------------
  //SETTING OPERATIONS

void DecisionConfig::setSelected(string decision)
{
  this->selected_decision = decision;
}


void DecisionConfig::setParams(std::map<std::string, CEBL::Param> params, string decision)
{
  if(decision=="")
    decision = selected_decision;

  if(decision == "")
    return;

  try
    {
      plugin_loader->getPlugin(decision)->setParamsList(params);
    }
  catch(...)
    {
      throw PluginException("Failed to set parameter list for decision: " 
                            + decision);
    }
}



void DecisionConfig::updateWithProbabilities
(std::vector<std::vector<double> >probs)
{
  string decision = selected_decision;
  plugin_loader->getPlugin(decision)->updateWithProbabilities(probs);
}

void DecisionConfig::updateWithProbabilities(std::vector<double> probs)
{
  string decision = selected_decision;
  plugin_loader->getPlugin(decision)->updateWithProbabilities(probs);
}

void DecisionConfig::updateWithClassification(ublas::vector<int> classes)
{
  string decision = selected_decision;
  plugin_loader->getPlugin(decision)->updateWithClassification(classes);
}

void DecisionConfig::updateWithClassification(int cls)
{
  string decision = selected_decision;
  plugin_loader->getPlugin(decision)->updateWithClassification(cls);
}

void DecisionConfig::init(int num_classes)
{
  string decision = selected_decision;
  plugin_loader->getPlugin(decision)->init(num_classes);
}

std::vector<double> DecisionConfig::decideClasses()
{
  string decision = selected_decision;
  return plugin_loader->getPlugin(decision)->decideClasses();
}

